#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_accum
def accum(vis='', tablein='', incrtable='', caltable='', field=[''], calfield=[''], interp='linear', accumtime=1.0, spwmap=[-1]):

        """Accumulate incremental calibration solutions into a calibration table

       Accum will interpolate and extrapolate a temporal calibration
       table onto a new table that has a regularly-space time grid.

       The first run of accum defines the time grid and fills this
       table with the results from the input table.

       Subsequent use of accum will combine additional calibration
       tables onto the same grid of the initial accum table to obtain
       an output accum table.  See below for a concrete example.


     Keyword arguments:

     vis -- Name of input visibility file
             default: none.  example: vis='ngc5921.ms'
     tablein -- Input cumulative calibration table.
             default: ''  means none
             On first execution of accum, tablein=''
             and accumtime is used to generate tablein with
             the specified time gridding.
     accumtime -- The time separation when making tablein.
             default: 1.0  (1 second).  This time should not be
             less than the visibiility sampling time, but should
             be less than about 30% of a typical scan length.
     incrtable -- The calibration data to be interpolated onto the
             tablein file.
             default: ''.  Must be specified
     caltable -- The output cumulated calibration file.
             default: ''  means use tablein as the output file
             
     field -- Select field(s) from tablein to process.
              ['go listobs' to obtain the list id's or names]
            default: ''= all fields
            If field string is a non-negative integer, it is assumed to
               be a field index otherwise, it is assumed to be a field name
            field='0~2'; field ids 0,1,2
            field='0,4,5~7'; field ids 0,4,5,6,7
            field='3C286,3C295'; field named 3C286 and 3C295
            field = '3,4C*'; field id 3, all names starting with 4C
     calfield -- Select field(s) from incrtable to process.
            default: '' = all fields
     interp -- Interpolation type (in time[,freq]) to use for each gaintable.
                When frequency interpolation is relevant (B, Df, Xf),
                separate time-dependent and freq-dependent interp
                types with a comma (freq _after_ the comma).                
                Specifications for frequency are ignored when the
                calibration table has no channel-dependence.
                Time-dependent interp options ending in 'PD' enable a
                "phase delay" correction per spw for non-channel-dependent
                calibration types.
                For multi-obsId datasets, 'perobs' can be appended to
                the time-dependent interpolation specification to
                enforce obsId boundaries when interpolating in time.
                default: '' --> 'linear,linear' for all gaintable(s)
                example: interp='nearest'   (in time, freq-dep will be
                                             linear, if relevant)
                         interp='linear,cubic'  (linear in time, cubic
                                                 in freq)
                         interp='linearperobs,spline' (linear in time
                                                       per obsId,
                                                       spline in freq)
                         interp=',spline'  (spline in freq; linear in
                                            time by default)
                         interp=['nearest,spline','linear']  (for multiple gaintables)
                Options: Time: 'nearest', 'linear'
                         Freq: 'nearest', 'linear', 'cubic', 'spline'
     spwmap -- Spectral windows combinations to form for gaintable(s)
            default: [] (apply solutions from each spw to that spw only)
            Example:  spwmap=[0,0,1,1] means apply the caltable solutions
                      from spw = 0 to the spw 0,1 and spw 1 to spw 2,3.
                      spwmap=[[0,0,1,1],[0,1,0,1]]  (for multiple gaintables)
     async -- Run task in a separate process 
             default: False; example: async=True

     Examples:

       Create an accum table with 10-sec sampling, filling it with the calibration
          in 'first_cal' with the desired interpolation.

           taskname = 'accum'
             default()
             vis = 'mydata.ms'
             tablein = ''
             accumtime = 10
             incrtable = 'first_cal'
             caltable = 'accum1_cal'
             accum()

       If you plot 'accum1_cal' with plotcal, you can see how the incrtable was
             interpolated.

       Continue accumulating calibrations in accum1_cal from 'second_cal'

           taskname = 'accum'
             default()
             vis = 'mydata.ms'
             tablein = 'accum1_cal'
             incrtable = 'second_cal'
             caltable = 'accum1_cal'
             accum()

  
 
        """
        if type(field)==str: field=[field]
        if type(calfield)==str: calfield=[calfield]
        if type(spwmap)==int: spwmap=[spwmap]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['tablein'] = tablein
        mytmp['incrtable'] = incrtable
        mytmp['caltable'] = caltable
        mytmp['field'] = field
        mytmp['calfield'] = calfield
        mytmp['interp'] = interp
        mytmp['accumtime'] = accumtime
        mytmp['spwmap'] = spwmap
	pathname='file://' + xmlpath( ) + '/'
	trec = casac.utils().torecord(pathname+'accum.xml')

        casalog.origin('accum')
        if trec.has_key('accum') and casac.utils().verify(mytmp, trec['accum']) :
	    result = task_accum.accum(vis, tablein, incrtable, caltable, field, calfield, interp, accumtime, spwmap)

	else :
	  result = False
        return result
