#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hsd_baseline import hsd_baseline
class hsd_baseline_cli_:
    __name__ = "hsd_baseline"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hsd_baseline_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'fitfunc':None, 'fitorder':None, 'linewindow':None, 'edge':None, 'broadline':None, 'clusteringalgorithm':None, 'deviationmask':None, 'pipelinemode':None, 'infiles':None, 'field':None, 'antenna':None, 'spw':None, 'pol':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, fitfunc=None, fitorder=None, linewindow=None, edge=None, broadline=None, clusteringalgorithm=None, deviationmask=None, pipelinemode=None, infiles=None, field=None, antenna=None, spw=None, pol=None, dryrun=None, acceptresults=None, ):

        """Detect and validate spectral lines, subtract baseline by masking detected lines

	Detailed Description: 


	Arguments :
		fitfunc:	Fitting function for baseline subtraction
		   Default Value: cspline
		   Allowed Values:
				cspline
				spline
				CSPLINE
				SPLINE

		fitorder:	Fitting order for baseline subtraction
		   Default Value: -1

		linewindow:	Pre-defined line window
		   Default Value: 

		edge:	Edge channels to be dropped
		   Default Value: 

		broadline:	Try to detect broad component of the line
		   Default Value: True

		clusteringalgorithm:	Algorithm for line validation clustering algorithm
		   Default Value: kmean
		   Allowed Values:
				kmean
				hierarchy

		deviationmask:	Apply deviation mask in addition to detected line masks
		   Default Value: True

		pipelinemode:	The pipeline operating mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		infiles:	List of input files to be calibrated (default all)
		   Default Value: 

		field:	select data by field
		   Default Value: 

		antenna:	select data by antenna
		   Default Value: 

		spw:	select data by IF IDs (spectral windows), e.g. \'3,5,7\' (\'\'=all)
		   Default Value: 

		pol:	select data by polarizations, e.g. \'0~1\' (\'\'=all)
		   Default Value: 

		dryrun:	Run the task (False) or display task command (True)
		   Default Value: False

		acceptresults:	Add the results into the pipeline context
		   Default Value: True

	Returns: void

	Example :

The hsd_baseline task subtracts baseline from calibrated spectra.
By default, the task tries to find spectral line feature using
line detection and validation algorithms. Then, the task puts a
mask on detected lines and perform baseline subtraction. The user
is able to turn off automatic line masking by setting linewindow
parameter, which specifies pre-defined line window. 

Fitting order is automatically determined by default. It can be
disabled by specifying fitorder as non-negative value. In this case,
the value specified by fitorder will be used.
  
Keyword arguments:

---- pipeline parameter arguments which can be set in any pipeline mode
fitfunc -- fitting function for baseline subtraction. You can only choose
   cubic spline ('spline' or 'cspline')
   default: 'cspline'.

fitorder -- Fitting order for polynomial. For cubic spline, it is used
   to determine how much the spectrum is segmented into. Default (-1) is
   to determine the order automatically.
   default: -1 (auto determination)

linewindow -- Pre-defined line window. If this is set, specified line 
   windows are used as a line mask for baseline subtraction instead to 
   determine masks based on line detection and validation stage. Two 
   types of format are acceptable. One is channel-based specification, 
   
      [min_chan,max_chan] 

   and the other is specification by central frequency in GHz plus 
   line range as velocity in km/s, 
   
      [center_freq, min_vel, max_vel]

   You can set multiple line windows by using nested list. However, 
   the above notation must not be mixed in the list for multiple line 
   windows.
   default: [] (do line detection and validation)
   example: [100.0,200.0], [115.0,-10.0,10.0]

edge -- number of edge channels to be dropped from baseline subtraction.
   the value must be a list with length of 2, whose values specifies
   left and right edge channels respectively.
   default: [] ([0,0])
   example: [10,10]

broadline -- Try to detect broad component of spectral line if True.
   default: True

clusteringalgorithm -- selection of the algorithm used in the clustering
   analysis to check the validity of detected line features. 'kmean'
   algorithm and hierarchical clustering algorithm 'hierarchy' are so
   far implemented.
   default: 'kmean'.
   
deviationmask -- Apply deviation mask in addition to masks determined by 
   the automatic line detection.
   default: True

pipelinemode -- The pipeline operating mode. In 'automatic' mode the 
   pipeline determines the values of all context defined pipeline inputs
   automatically.  In 'interactive' mode the user can set the pipeline
   context defined parameters manually.  In 'getinputs' mode the user
   can check the settings of all pipeline parameters without running
   the task.
   default: 'automatic'.

---- pipeline context defined parameter argument which can be set only in
'interactive mode'

infiles -- List of data files. These must be a name of Scantables that 
   are registered to context via hsd_importdata task.
   default: []
   example: vis=['X227.ms', 'X228.ms']
   
field -- Data selection by field.
   default: '' (all fields)
   example: '1' (select by FIELD_ID)
            'M100*' (select by field name)

antenna -- Data selection by antenna.
   default: '' (all antennas)
   example: '1' (select by ANTENNA_ID)
            'PM03' (select by antenna name)

spw -- Data selection by spw.
   default: '' (all spws)
   example: '3,4' (generate caltable for spw 3 and 4)
            ['0','2'] (spw 0 for first data, 2 for second)

pol -- Data selection by pol.
   default: '' (all polarizations)
   example: '0' (generate caltable for pol 0)
            ['0~1','0'] (pol 0 and 1 for first data, only 0 for second)

--- pipeline task execution modes

dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: True

acceptresults -- Add the results of the task to the pipeline context (True) or
   reject them (False).
   default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
   the results object for the pipeline task is returned.


Examples



        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hsd_baseline'
        self.__globals__['taskname'] = 'hsd_baseline'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['fitfunc'] = fitfunc = self.parameters['fitfunc']
            myparams['fitorder'] = fitorder = self.parameters['fitorder']
            myparams['linewindow'] = linewindow = self.parameters['linewindow']
            myparams['edge'] = edge = self.parameters['edge']
            myparams['broadline'] = broadline = self.parameters['broadline']
            myparams['clusteringalgorithm'] = clusteringalgorithm = self.parameters['clusteringalgorithm']
            myparams['deviationmask'] = deviationmask = self.parameters['deviationmask']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['infiles'] = infiles = self.parameters['infiles']
            myparams['field'] = field = self.parameters['field']
            myparams['antenna'] = antenna = self.parameters['antenna']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['pol'] = pol = self.parameters['pol']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(linewindow)==int: linewindow=[linewindow]
        if type(edge)==int: edge=[edge]
        if type(infiles)==str: infiles=[infiles]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['fitfunc'] = fitfunc
        mytmp['fitorder'] = fitorder
        mytmp['linewindow'] = linewindow
        mytmp['edge'] = edge
        mytmp['broadline'] = broadline
        mytmp['clusteringalgorithm'] = clusteringalgorithm
        mytmp['deviationmask'] = deviationmask
        mytmp['pipelinemode'] = pipelinemode
        mytmp['infiles'] = infiles
        mytmp['field'] = field
        mytmp['antenna'] = antenna
        mytmp['spw'] = spw
        mytmp['pol'] = pol
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hsd/cli/"
	trec = casac.casac.utils().torecord(pathname+'hsd_baseline.xml')

        casalog.origin('hsd_baseline')
	try :
          #if not trec.has_key('hsd_baseline') or not casac.casac.utils().verify(mytmp, trec['hsd_baseline']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hsd_baseline'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hsd_baseline', 'hsd_baseline.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hsd_baseline'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hsd_baseline(fitfunc, fitorder, linewindow, edge, broadline, clusteringalgorithm, deviationmask, pipelinemode, infiles, field, antenna, spw, pol, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hsd_baseline'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hsd_baseline', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['fitfunc']  = 'cspline'
        a['fitorder']  = -1
        a['linewindow']  = []
        a['edge']  = []
        a['broadline']  = True
        a['clusteringalgorithm']  = 'kmean'
        a['deviationmask']  = True
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'infiles':[]}, {'field':''}, {'antenna':''}, {'spw':''}, {'pol':''}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'infiles':[]}, {'field':''}, {'antenna':''}, {'spw':''}, {'pol':''}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hsd_baseline', subkey=None):
        desc={'hsd_baseline': 'Detect and validate spectral lines, subtract baseline by masking detected lines',
               'fitfunc': 'Fitting function for baseline subtraction',
               'fitorder': 'Fitting order for baseline subtraction',
               'linewindow': 'Pre-defined line window',
               'edge': 'Edge channels to be dropped',
               'broadline': 'Try to detect broad component of the line',
               'clusteringalgorithm': 'Algorithm for line validation clustering algorithm',
               'deviationmask': 'Apply deviation mask in addition to detected line masks',
               'pipelinemode': 'The pipeline operating mode',
               'infiles': 'List of input files to be calibrated (default all)',
               'field': 'select data by field',
               'antenna': 'select data by antenna',
               'spw': 'select data by IF IDs (spectral windows), e.g. \'3,5,7\' (\'\'=all)',
               'pol': 'select data by polarizations, e.g. \'0~1\' (\'\'=all)',
               'dryrun': 'Run the task (False) or display task command (True)',
               'acceptresults': 'Add the results into the pipeline context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['fitfunc']  = 'cspline'
        a['fitorder']  = -1
        a['linewindow']  = []
        a['edge']  = []
        a['broadline']  = True
        a['clusteringalgorithm']  = 'kmean'
        a['deviationmask']  = True
        a['pipelinemode']  = 'automatic'
        a['infiles']  = ['']
        a['field']  = ''
        a['antenna']  = ''
        a['spw']  = ''
        a['pol']  = ''
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['infiles'] = []
            a['field'] = ''
            a['antenna'] = ''
            a['spw'] = ''
            a['pol'] = ''
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['infiles'] = []
            a['field'] = ''
            a['antenna'] = ''
            a['spw'] = ''
            a['pol'] = ''

        if a.has_key(paramname) :
	      return a[paramname]
hsd_baseline_cli = hsd_baseline_cli_()
