#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_hsd_baseline
def hsd_baseline(fitfunc='cspline', fitorder=-1, linewindow=[], edge=[], broadline=True, clusteringalgorithm='kmean', deviationmask=True, pipelinemode='automatic', infiles=[''], field='', antenna='', spw='', pol='', dryrun=False, acceptresults=True):

        """Detect and validate spectral lines, subtract baseline by masking detected lines
The hsd_baseline task subtracts baseline from calibrated spectra.
By default, the task tries to find spectral line feature using
line detection and validation algorithms. Then, the task puts a
mask on detected lines and perform baseline subtraction. The user
is able to turn off automatic line masking by setting linewindow
parameter, which specifies pre-defined line window. 

Fitting order is automatically determined by default. It can be
disabled by specifying fitorder as non-negative value. In this case,
the value specified by fitorder will be used.
  
Keyword arguments:

---- pipeline parameter arguments which can be set in any pipeline mode
fitfunc -- fitting function for baseline subtraction. You can only choose
   cubic spline ('spline' or 'cspline')
   default: 'cspline'.

fitorder -- Fitting order for polynomial. For cubic spline, it is used
   to determine how much the spectrum is segmented into. Default (-1) is
   to determine the order automatically.
   default: -1 (auto determination)

linewindow -- Pre-defined line window. If this is set, specified line 
   windows are used as a line mask for baseline subtraction instead to 
   determine masks based on line detection and validation stage. Two 
   types of format are acceptable. One is channel-based specification, 
   
      [min_chan,max_chan] 

   and the other is specification by central frequency in GHz plus 
   line range as velocity in km/s, 
   
      [center_freq, min_vel, max_vel]

   You can set multiple line windows by using nested list. However, 
   the above notation must not be mixed in the list for multiple line 
   windows.
   default: [] (do line detection and validation)
   example: [100.0,200.0], [115.0,-10.0,10.0]

edge -- number of edge channels to be dropped from baseline subtraction.
   the value must be a list with length of 2, whose values specifies
   left and right edge channels respectively.
   default: [] ([0,0])
   example: [10,10]

broadline -- Try to detect broad component of spectral line if True.
   default: True

clusteringalgorithm -- selection of the algorithm used in the clustering
   analysis to check the validity of detected line features. 'kmean'
   algorithm and hierarchical clustering algorithm 'hierarchy' are so
   far implemented.
   default: 'kmean'.
   
deviationmask -- Apply deviation mask in addition to masks determined by 
   the automatic line detection.
   default: True

pipelinemode -- The pipeline operating mode. In 'automatic' mode the 
   pipeline determines the values of all context defined pipeline inputs
   automatically.  In 'interactive' mode the user can set the pipeline
   context defined parameters manually.  In 'getinputs' mode the user
   can check the settings of all pipeline parameters without running
   the task.
   default: 'automatic'.

---- pipeline context defined parameter argument which can be set only in
'interactive mode'

infiles -- List of data files. These must be a name of Scantables that 
   are registered to context via hsd_importdata task.
   default: []
   example: vis=['X227.ms', 'X228.ms']
   
field -- Data selection by field.
   default: '' (all fields)
   example: '1' (select by FIELD_ID)
            'M100*' (select by field name)

antenna -- Data selection by antenna.
   default: '' (all antennas)
   example: '1' (select by ANTENNA_ID)
            'PM03' (select by antenna name)

spw -- Data selection by spw.
   default: '' (all spws)
   example: '3,4' (generate caltable for spw 3 and 4)
            ['0','2'] (spw 0 for first data, 2 for second)

pol -- Data selection by pol.
   default: '' (all polarizations)
   example: '0' (generate caltable for pol 0)
            ['0~1','0'] (pol 0 and 1 for first data, only 0 for second)

--- pipeline task execution modes

dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: True

acceptresults -- Add the results of the task to the pipeline context (True) or
   reject them (False).
   default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
   the results object for the pipeline task is returned.


Examples



        """
        if type(linewindow)==int: linewindow=[linewindow]
        if type(edge)==int: edge=[edge]
        if type(infiles)==str: infiles=[infiles]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['fitfunc'] = fitfunc
        mytmp['fitorder'] = fitorder
        mytmp['linewindow'] = linewindow
        mytmp['edge'] = edge
        mytmp['broadline'] = broadline
        mytmp['clusteringalgorithm'] = clusteringalgorithm
        mytmp['deviationmask'] = deviationmask
        mytmp['pipelinemode'] = pipelinemode
        mytmp['infiles'] = infiles
        mytmp['field'] = field
        mytmp['antenna'] = antenna
        mytmp['spw'] = spw
        mytmp['pol'] = pol
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hsd/cli/"
	trec = casac.utils().torecord(pathname+'hsd_baseline.xml')

        casalog.origin('hsd_baseline')
        if trec.has_key('hsd_baseline') and casac.utils().verify(mytmp, trec['hsd_baseline']) :
	    result = task_hsd_baseline.hsd_baseline(fitfunc, fitorder, linewindow, edge, broadline, clusteringalgorithm, deviationmask, pipelinemode, infiles, field, antenna, spw, pol, dryrun, acceptresults)

	else :
	  result = False
        return result
