#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_uvcontfit import hif_uvcontfit
class hif_uvcontfit_cli_:
    __name__ = "hif_uvcontfit"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_uvcontfit_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'caltable':None, 'contfile':None, 'field':None, 'intent':None, 'spw':None, 'combine':None, 'solint':None, 'fitorder':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, caltable=None, contfile=None, field=None, intent=None, spw=None, combine=None, solint=None, fitorder=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Fit the continuum in the UV plane

	Detailed Description: 

Fit the continuum in the UV plane using polynomials.

	Arguments :
		vis:	The name of the input visibility file
		   Default Value: 

		caltable:	Name of output mueller matrix calibration table
		   Default Value: 

		contfile:	Name of the input file of per source / spw continuum regions
		   Default Value: 

		field:	Select field(s) using id(s) or name(s)
		   Default Value: 

		intent:	Select intents
		   Default Value: 

		spw:	Spectral window / channels for fitting the continuum
		   Default Value: 

		combine:	Data axes to combine for the continuum estimation (none, spw and/or scan)
		   Default Value: 

		solint:	Time scale for the continuum fit
		   Default Value: int

		fitorder:	Polynomial order for the continuum fits
		   Default Value: 1

		pipelinemode:	The pipeline operating mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run the task (False) or display the command(True)
		   Default Value: False

		acceptresults:	Add the results to the pipeline context
		   Default Value: True

	Returns: void

	Example :


This task estimates the continuum emission by fitting polynomials to
the real and imaginary parts of the spectral windows and channels
selected by spw and exclude spw. This fit represents a model of
the continuum in all channels. Fit orders less than 2 are strongly
recommended. Spw window combination is not currently supported.
	

Keyword Arguments


pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
    determines the values of all context defined pipeline inputs automatically.
    In 'interactive' mode the user can set the pipeline context defined
    parameters manually.  In 'getinputs' mode the user can check the settings
    of all pipeline parameters without running the task.
    default: 'automatic'.

--- pipeline parameter arguments which can be set in any pipeline mode

solint --
    default: 'int'
    example: solint='30s'

fitorder -- The fit order of the polynomials.
    default: 1
    example: fitorder = 0

---- pipeline context defined parameter arguments which can be set only in
     'interactive mode'

vis -- The list of input MeasurementSets for which the UV continuum fits are
    to be generated. Defaults to the list of imaging MeasurementSets specified
    in the pipeline import data task.
    default '': Compute the continuum fit for all calibration MeasurementSets in the context.
    example: 'ngc5921.ms', ['ngc5921a.ms', ngc5921b.ms', 'ngc5921c.ms']

caltable -- The list of output calibration tables one per input MS. 
    default: '', The output name defaults to the standard pipeline name scheme
    example: ['M51.uvcont']

contfile -- The file containing the continuum frequency ranges used for the 
    continuum fit.
    default: '', Defaults first to the file named in the context, next to a file called
             'cont.dat' in the pipeline working directory, or ''
    example: contfile = 'mycontfile'

field -- The list of field names or field ids for which UV continuum fits are
    computed. Defaults to all fields.
    default: ''
    example: '3C279', '3C279, M82'

intent -- A string containing a comma delimited list of intents against
    which the the selected fields are matched.
    default: '', Defaults to all data with TARGET intent.
    example: 'PHASE'

spw -- The list of spectral windows and channels for which uv continuum
    fits are computed.
    default: '', Defaults to all science spectral windows.
    example: '11,13,15,17'

combine -- Data axes to be combined for solving. Axes are 'scan', 'spw', or ''.
    This option is currently not supported.
    default: '', None.
    example: combine= 'scan'



        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_uvcontfit'
        self.__globals__['taskname'] = 'hif_uvcontfit'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['caltable'] = caltable = self.parameters['caltable']
            myparams['contfile'] = contfile = self.parameters['contfile']
            myparams['field'] = field = self.parameters['field']
            myparams['intent'] = intent = self.parameters['intent']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['combine'] = combine = self.parameters['combine']
            myparams['solint'] = solint = self.parameters['solint']
            myparams['fitorder'] = fitorder = self.parameters['fitorder']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(vis)==str: vis=[vis]
        if type(caltable)==str: caltable=[caltable]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['caltable'] = caltable
        mytmp['contfile'] = contfile
        mytmp['field'] = field
        mytmp['intent'] = intent
        mytmp['spw'] = spw
        mytmp['combine'] = combine
        mytmp['solint'] = solint
        mytmp['fitorder'] = fitorder
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_uvcontfit.xml')

        casalog.origin('hif_uvcontfit')
	try :
          #if not trec.has_key('hif_uvcontfit') or not casac.casac.utils().verify(mytmp, trec['hif_uvcontfit']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_uvcontfit'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_uvcontfit', 'hif_uvcontfit.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_uvcontfit'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_uvcontfit(vis, caltable, contfile, field, intent, spw, combine, solint, fitorder, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_uvcontfit'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_uvcontfit', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['solint']  = 'int'
        a['fitorder']  = 1
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'vis':[]}, {'caltable':[]}, {'contfile':''}, {'field':''}, {'intent':''}, {'spw':''}, {'combine':''}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'vis':[]}, {'caltable':[]}, {'contfile':''}, {'field':''}, {'intent':''}, {'spw':''}, {'combine':''}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_uvcontfit', subkey=None):
        desc={'hif_uvcontfit': 'Fit the continuum in the UV plane',
               'vis': 'The name of the input visibility file',
               'caltable': 'Name of output mueller matrix calibration table',
               'contfile': 'Name of the input file of per source / spw continuum regions',
               'field': 'Select field(s) using id(s) or name(s)',
               'intent': 'Select intents',
               'spw': 'Spectral window / channels for fitting the continuum',
               'combine': 'Data axes to combine for the continuum estimation (none, spw and/or scan)',
               'solint': 'Time scale for the continuum fit',
               'fitorder': 'Polynomial order for the continuum fits',
               'pipelinemode': 'The pipeline operating mode',
               'dryrun': 'Run the task (False) or display the command(True)',
               'acceptresults': 'Add the results to the pipeline context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['caltable']  = ['']
        a['contfile']  = ''
        a['field']  = ''
        a['intent']  = ''
        a['spw']  = ''
        a['combine']  = ''
        a['solint']  = 'int'
        a['fitorder']  = 1
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['vis'] = []
            a['caltable'] = []
            a['contfile'] = ''
            a['field'] = ''
            a['intent'] = ''
            a['spw'] = ''
            a['combine'] = ''
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['vis'] = []
            a['caltable'] = []
            a['contfile'] = ''
            a['field'] = ''
            a['intent'] = ''
            a['spw'] = ''
            a['combine'] = ''

        if a.has_key(paramname) :
	      return a[paramname]
hif_uvcontfit_cli = hif_uvcontfit_cli_()
