#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_tclean import hif_tclean
class hif_tclean_cli_:
    __name__ = "hif_tclean"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_tclean_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'imagename':None, 'intent':None, 'field':None, 'spw':None, 'spwsel_lsrk':None, 'spwsel_topo':None, 'uvrange':None, 'specmode':None, 'gridder':None, 'deconvolver':None, 'nterms':None, 'outframe':None, 'imsize':None, 'cell':None, 'phasecenter':None, 'stokes':None, 'nchan':None, 'start':None, 'width':None, 'nbin':None, 'weighting':None, 'robust':None, 'noise':None, 'npixels':None, 'restoringbeam':None, 'hm_masking':None, 'hm_sidelobethreshold':None, 'hm_noisethreshold':None, 'hm_lownoisethreshold':None, 'hm_negativethreshold':None, 'hm_minbeamfrac':None, 'hm_growiterations':None, 'hm_dogrowprune':None, 'hm_minpercentchange':None, 'hm_cleaning':None, 'mask':None, 'niter':None, 'threshold':None, 'tlimit':None, 'masklimit':None, 'maxncleans':None, 'cleancontranges':None, 'parallel':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, imagename=None, intent=None, field=None, spw=None, spwsel_lsrk=None, spwsel_topo=None, uvrange=None, specmode=None, gridder=None, deconvolver=None, nterms=None, outframe=None, imsize=None, cell=None, phasecenter=None, stokes=None, nchan=None, start=None, width=None, nbin=None, weighting=None, robust=None, noise=None, npixels=None, restoringbeam=None, hm_masking=None, hm_sidelobethreshold=None, hm_noisethreshold=None, hm_lownoisethreshold=None, hm_negativethreshold=None, hm_minbeamfrac=None, hm_growiterations=None, hm_dogrowprune=None, hm_minpercentchange=None, hm_cleaning=None, mask=None, niter=None, threshold=None, tlimit=None, masklimit=None, maxncleans=None, cleancontranges=None, parallel=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Compute clean map

	Detailed Description: 

Compute a clean map.  

	Arguments :
		vis:	List of input MeasurementSets, \'\' for default
		   Default Value: 

		imagename:	Prefix for image filenames, \'\' for default
		   Default Value: 

		intent:	Set of data selection intents, \'\' for all
		   Default Value: 

		field:	Set of data selection field names or ids
		   Default Value: 

		spw:	Set of data selection spectral window/channels \'\' for all
		   Default Value: 

		spwsel_lsrk:	Dictionary of LSRK spw frequency selections, {} for automatic
		   Default Value: {}

		spwsel_topo:	List of TOPO spw frequency selections per MS, [] for automatic
		   Default Value: {}

		uvrange:	Set of uv ranges, \'\' for all
		   Default Value: 

		specmode:	Spectral gridding type (mfs, cont, cube, \'\' for default)
		   Default Value: 
		   Allowed Values:
				
				mfs
				cont
				cube

		gridder:	Gridding options (standard, mosaic, \'\' for default)
		   Default Value: 
		   Allowed Values:
				
				standard
				mosaic

		deconvolver:	Minor cycle algorithm (hogbom, clark, mtmfs, \'\' for default)
		   Default Value: 
		   Allowed Values:
				
				hogbom
				clark
				mtmfs

		nterms:	Number of terms when deconvolver=\'mtmfs\'
		   Default Value: 2

		outframe:	velocity frame of output image (LSRK, \'\' for default)
		   Default Value: 
		   Allowed Values:
				
				LSRK

		imsize:	X and Y image size in pixels, single value same for both, \'\' for default
		   Default Value: 

		cell:	X and Y cell size(s), single value same for both, \'\' for default
		   Default Value: 

		phasecenter:	Image center (direction or field index), \'\' for default
		   Default Value: 

		stokes:	Stokes Planes to make
		   Default Value: I
		   Allowed Values:
				I
				Q
				U
				V

		nchan:	Number of channels or planes in output image, -1 = all
		   Default Value: -1

		start:	Start of output spectral dimension
		   Default Value: 

		width:	Width of output spectral channels, \'\' for default
		   Default Value: 

		nbin:	Channel binning factor, -1 for default.
		   Default Value: -1

		weighting:	Type of weighting
		   Default Value: briggs
		   Allowed Values:
				briggs
				natural
				uniform
				superuniform
				briggsabs

		robust:	Briggs weighting robustness parameter
		   Default Value: -999.0

		noise:	Briggs weighting noise parameter
		   Default Value: 1.0Jy

		npixels:	Weighting algorithm parameter
		   Default Value: 0

		restoringbeam:	Gaussian restoring beam, \'\' for default
		   Default Value: 

		hm_masking:	Pipeline heuristics masking option
		   Default Value: auto
		   Allowed Values:
				auto
				centralregion
				psf
				psfiter
				manual
				none
				

		hm_sidelobethreshold:	sidelobethreshold * the max sidelobe level
		   Default Value: -999.0

		hm_noisethreshold:	noisethreshold * rms in residual image
		   Default Value: -999.0

		hm_lownoisethreshold:	lownoisethreshold * rms in residual image
		   Default Value: -999.0

		hm_negativethreshold:	negativethreshold * rms in residual image
		   Default Value: -999.0

		hm_minbeamfrac:	minimum beam fraction for pruning
		   Default Value: -999.0

		hm_growiterations:	number of binary dilation iterations for growing the mask
		   Default Value: -999

		hm_dogrowprune:	Do pruning on the grow mask
		   Default Value: True

		hm_minpercentchange:	Mask size change threshold
		   Default Value: -999.0

		hm_cleaning:	Pipeline clean control heuristics
		   Default Value: rms
		   Allowed Values:
				rms
				sensitivity
				timesmask
				manual

		mask:	User mask, \'\' for whole image
		   Default Value: 

		niter:	Maximum number of clean iterations
		   Default Value: 5000

		threshold:	Flux level to stop cleaning, must include units: \'1.0mJy\'
		   Default Value: 0.0

		tlimit:	Times the sensitivity limit for cleaning
		   Default Value: 2.0

		masklimit:	Times good mask pixels for cleaning
		   Default Value: 4

		maxncleans:	Maximum number of clean task calls
		   Default Value: 1

		cleancontranges:	Clean continuum frequency ranges in cubes
		   Default Value: False

		parallel:	Clean images using MPI cluster
		   Default Value: automatic
		   Allowed Values:
				automatic
				true
				false

		pipelinemode:	The pipeline operating mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run the task (False) or display the command(True)
		   Default Value: False

		acceptresults:	Add the results to the pipeline context
		   Default Value: True

	Returns: void

	Example :


Compute a cleaned image for a particular target source/intent and spectral
window.

Keyword arguments:

--- pipeline parameter arguments which can be set in any pipeline mode

pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
       determines the values of all context defined pipeline inputs
       automatically.  In interactive mode the user can set the pipeline
       context defined parameters manually.  In 'getinputs' mode the user
       can check the settings of all pipeline parameters without running
       the task.
       default: 'automatic'.


---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- The list of input MeasurementSets. Defaults to the list of
    MeasurementSets in the context.
    default: ''
    example: vis=['ngc5921a.ms', ngc5921b.ms', 'ngc5921c.ms']

imagename -- Prefix of output images. Defaults to one of the following options
   depending on the availability of project information. 
   '{ousstatus uid}.{field}.[{intent}.]s{stage number}.spw{spw}'
   'multivis.{field}.[{intent}.]s{stage number}.spw{spw}'

   cleanboxes and thresholds to use as it goes. For each iteration the
   output images are:
      {prename}.iter{n}.image; cleaned and restored image
      {prename}.iter{n}.psf; point spread function (dirty beam)
      {prename}.iter{n}.flux; relative sky sensitivity over field
      {prename}.iter{n}.flux.pbcoverage; relative pb coverage over field
                                        (only for mosaics)
      {prename}.iter{n}.model; image of clean components
      {prename}.iter{n}.residual; image of residuals
      {prename}.iter{n}.cleanmask; image of cleanmask used
   default: ''
   example: 'test1'
  
intent -- An intent against which the selected fields are matched. Default
    means select all data from fields specified by 'field' paramete
    default: ''
    example: '', 'TARGET'

field -- Fields id(s) or name(s) to image or mosaic. Must be set.
    default:  
    example: '3C279', 'Centaurus*'

spw -- Spectral window/channels to image. \'\' for all science data.
    default: ''
    example: '9', '9,11'

spwsel_lsrk -- Spectral window LSRK frequency selection for continuum. {} for all science data.
    default: {}
    example: {'spw16': '89.1~89.5GHz;90.2~90.3GHz', 'spw18': '101.2~102.1GHz'}

spwsel_topo -- Per MS spectral window TOPO frequency selection for continuum. [] for all science data.
    default: {}
    example: {['spw16:89.1~89.5GHz;90.2~90.3GHz']}

specmode -- Frequency imaging mode, 'mfs', 'cont', 'cube'. \'\' defaults to
    'cube' if intent parameter includes 'TARGET' otherwise 'mfs'.
    default: ''
    example: 'mfs', 'cont', 'cube'

gridder -- Gridding options, 'standard', 'mosaic'.
   Derived as follows:
      1. The 'field' parameter is converted into a list of field_ids for
         each MeasurementSet in 'vis'.
      2. If there is more than 1 field_id in the list for any MeasurementSet
         then gridder is set to 'mosaic', otherwise it will be set
         to 'standard'. 
    default: ''
    'standard'

deconvolver -- Minor cycle algorithm e.g. hogbom or clark clean. \'\' defaults to
    'hogbom'

outframe -- The reference frame of the output image. The only supported option
    is 'LSRK'
    default: ''
    example: 'LSRK'

imsize -- X and Y image size in pixels).  Must be even and contain factors
    2,3,5,7 only.
    Default derived as follows:
      1. Determine 'phasecenter' value and spread of field centres around it. 
      2. Set size of image to cover spread of field centres plus a border of
         width 0.75 * beam radius (to first null).
      3. Divide x and y extents by 'cell' values to arrive at the numbers of
         pixels required. 
    default: ''
    example: [320,320]

cell -- X and Y cell size. Derived from maximum UV spacing. Details TBD
    default ''
    example: ['0.5arcsec', '0.5arcsec']

phasecenter -- Direction measure or field id for the mosaic center.
   Default derived as follows:
       1. Make an array containing all the field centers to be imaged together.
       2. Derive the mean direction from the directions array.
    default: \'\'
    example: 2

stokes --

nchan -- Number of channels or planes in the output image, -1 for all
    default: -1
    example: 128

width -- Width of spectral dimension in frequency, \'\' for default.
    default: \'\'
    example: '7.8125MHz'

nbin -- Channel binning factor
    default: -1
    example: 2

weighting -- Weighting to apply to visibilities. Options are: 'natural',
    'uniform','briggs', 'superuniform','briggsabs','radial'
     default='briggs'
     example: weighting='uniform'

robust -- Parameter for  'briggs' and 'briggsabs' weighting. Ranges from -2.0 to
    2.0. -2 for uniform +2 for natural.
    default=-999.0
    example: 0.7

noise -- Parameter for 'briggsabs' weighting
    default: '1.0Jy'
    example: '0.5Jy'

npixels -- Parameter for 'briggs' and 'briggsabs; weighting
    default: 0
    example: 0

restoringbeam -- Gaussian restoring beam for clean, \'\' for default
    default: \'\'
    example:

hm_masking -- Clean masking mode. Options are 'centralregion',
    'psf', 'psfiter', 'auto', 'manual' and 'none'
    default: 'auto'
    example: 'manual'

hm_sidelobethreshold -- Auto-boxing sidelobetheshold.

hm_noisethreshold -- Auto-boxing noisethreshold.

hm_lownoisethreshold -- Auto-boxing lownoisethreshold.

hm_negativethreshold -- Auto-boxing negativethreshold.

hm_minbeamfrac -- Auto-boxing minbeamfrac.

hm_growiterations -- number of binary dilation iterations for growing the mask.

hm_dogrowprune -- Do pruning on the grow mask

hm_minpercentchange -- Mask size change threshold

mask -- Image mask for hm_masking manual mode. User responsible for
    matching image sizes, coordinates, etc.
    default: \'\'
    example: 'mymask.mask'

niter -- Maximum number of iterations per clean call
    default: 5000
    example: 500

threshold -- Threshold for cleaning
    default: '0.0'
    example: '0.05'

maxncleans -- Maximum number of clean calls
    default: 1
    example: 10

cleancontranges -- Clean continuum frequency ranges in cubes
                   default=False
                   Options: False, True

parallel -- use MPI cluster to clean images
    default: \'automatic\'

--- pipeline task execution modes
dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: False

acceptresults -- Add the results of the task to the pipeline context (True) or
   reject them (False).
   default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.


Examples:

Make an 'mfs' image of calibrator 3c279 using data in spectral window 1. 
The cell size is set to 0.2 arcsec in RA and Dec. Other clean parameters
are derived from heuristics:

hif_tclean(field='3c279', cell='0.2arcsec', spw='1', specmode='mfs')

Make a cube of calibrator 3c279 using data in spectral window 1. The
cube planes will be evenly spaced in frequency in the LSRK frame. Other
clean parameters are derived from heuristics.
 
hif_tclean(field='3c279', cell='0.2arcsec', spw='1', specmode='cube',
 outframe='LSRK')


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_tclean'
        self.__globals__['taskname'] = 'hif_tclean'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['imagename'] = imagename = self.parameters['imagename']
            myparams['intent'] = intent = self.parameters['intent']
            myparams['field'] = field = self.parameters['field']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['spwsel_lsrk'] = spwsel_lsrk = self.parameters['spwsel_lsrk']
            myparams['spwsel_topo'] = spwsel_topo = self.parameters['spwsel_topo']
            myparams['uvrange'] = uvrange = self.parameters['uvrange']
            myparams['specmode'] = specmode = self.parameters['specmode']
            myparams['gridder'] = gridder = self.parameters['gridder']
            myparams['deconvolver'] = deconvolver = self.parameters['deconvolver']
            myparams['nterms'] = nterms = self.parameters['nterms']
            myparams['outframe'] = outframe = self.parameters['outframe']
            myparams['imsize'] = imsize = self.parameters['imsize']
            myparams['cell'] = cell = self.parameters['cell']
            myparams['phasecenter'] = phasecenter = self.parameters['phasecenter']
            myparams['stokes'] = stokes = self.parameters['stokes']
            myparams['nchan'] = nchan = self.parameters['nchan']
            myparams['start'] = start = self.parameters['start']
            myparams['width'] = width = self.parameters['width']
            myparams['nbin'] = nbin = self.parameters['nbin']
            myparams['weighting'] = weighting = self.parameters['weighting']
            myparams['robust'] = robust = self.parameters['robust']
            myparams['noise'] = noise = self.parameters['noise']
            myparams['npixels'] = npixels = self.parameters['npixels']
            myparams['restoringbeam'] = restoringbeam = self.parameters['restoringbeam']
            myparams['hm_masking'] = hm_masking = self.parameters['hm_masking']
            myparams['hm_sidelobethreshold'] = hm_sidelobethreshold = self.parameters['hm_sidelobethreshold']
            myparams['hm_noisethreshold'] = hm_noisethreshold = self.parameters['hm_noisethreshold']
            myparams['hm_lownoisethreshold'] = hm_lownoisethreshold = self.parameters['hm_lownoisethreshold']
            myparams['hm_negativethreshold'] = hm_negativethreshold = self.parameters['hm_negativethreshold']
            myparams['hm_minbeamfrac'] = hm_minbeamfrac = self.parameters['hm_minbeamfrac']
            myparams['hm_growiterations'] = hm_growiterations = self.parameters['hm_growiterations']
            myparams['hm_dogrowprune'] = hm_dogrowprune = self.parameters['hm_dogrowprune']
            myparams['hm_minpercentchange'] = hm_minpercentchange = self.parameters['hm_minpercentchange']
            myparams['hm_cleaning'] = hm_cleaning = self.parameters['hm_cleaning']
            myparams['mask'] = mask = self.parameters['mask']
            myparams['niter'] = niter = self.parameters['niter']
            myparams['threshold'] = threshold = self.parameters['threshold']
            myparams['tlimit'] = tlimit = self.parameters['tlimit']
            myparams['masklimit'] = masklimit = self.parameters['masklimit']
            myparams['maxncleans'] = maxncleans = self.parameters['maxncleans']
            myparams['cleancontranges'] = cleancontranges = self.parameters['cleancontranges']
            myparams['parallel'] = parallel = self.parameters['parallel']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(vis)==str: vis=[vis]
        if type(imsize)==int: imsize=[imsize]
        if type(cell)==str: cell=[cell]
        if type(restoringbeam)==str: restoringbeam=[restoringbeam]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['intent'] = intent
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['spwsel_lsrk'] = spwsel_lsrk
        mytmp['spwsel_topo'] = spwsel_topo
        mytmp['uvrange'] = uvrange
        mytmp['specmode'] = specmode
        mytmp['gridder'] = gridder
        mytmp['deconvolver'] = deconvolver
        mytmp['nterms'] = nterms
        mytmp['outframe'] = outframe
        mytmp['imsize'] = imsize
        mytmp['cell'] = cell
        mytmp['phasecenter'] = phasecenter
        mytmp['stokes'] = stokes
        mytmp['nchan'] = nchan
        mytmp['start'] = start
        mytmp['width'] = width
        mytmp['nbin'] = nbin
        mytmp['weighting'] = weighting
        mytmp['robust'] = robust
        mytmp['noise'] = noise
        mytmp['npixels'] = npixels
        mytmp['restoringbeam'] = restoringbeam
        mytmp['hm_masking'] = hm_masking
        mytmp['hm_sidelobethreshold'] = hm_sidelobethreshold
        mytmp['hm_noisethreshold'] = hm_noisethreshold
        mytmp['hm_lownoisethreshold'] = hm_lownoisethreshold
        mytmp['hm_negativethreshold'] = hm_negativethreshold
        mytmp['hm_minbeamfrac'] = hm_minbeamfrac
        mytmp['hm_growiterations'] = hm_growiterations
        mytmp['hm_dogrowprune'] = hm_dogrowprune
        mytmp['hm_minpercentchange'] = hm_minpercentchange
        mytmp['hm_cleaning'] = hm_cleaning
        mytmp['mask'] = mask
        mytmp['niter'] = niter
        if type(threshold) == str :
           mytmp['threshold'] = casac.casac.qa.quantity(threshold)
        else :
           mytmp['threshold'] = threshold
        mytmp['tlimit'] = tlimit
        mytmp['masklimit'] = masklimit
        mytmp['maxncleans'] = maxncleans
        mytmp['cleancontranges'] = cleancontranges
        mytmp['parallel'] = parallel
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_tclean.xml')

        casalog.origin('hif_tclean')
	try :
          #if not trec.has_key('hif_tclean') or not casac.casac.utils().verify(mytmp, trec['hif_tclean']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_tclean'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_tclean', 'hif_tclean.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_tclean'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_tclean(vis, imagename, intent, field, spw, spwsel_lsrk, spwsel_topo, uvrange, specmode, gridder, deconvolver, nterms, outframe, imsize, cell, phasecenter, stokes, nchan, start, width, nbin, weighting, robust, noise, npixels, restoringbeam, hm_masking, hm_sidelobethreshold, hm_noisethreshold, hm_lownoisethreshold, hm_negativethreshold, hm_minbeamfrac, hm_growiterations, hm_dogrowprune, hm_minpercentchange, hm_cleaning, mask, niter, threshold, tlimit, masklimit, maxncleans, cleancontranges, parallel, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_tclean'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_tclean', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['specmode']  = ''
        a['imsize']  = []
        a['cell']  = ['']
        a['stokes']  = 'I'
        a['width']  = ''
        a['nbin']  = -1
        a['weighting']  = 'briggs'
        a['hm_masking']  = 'auto'
        a['hm_cleaning']  = 'rms'
        a['cleancontranges']  = False
        a['parallel']  = 'automatic'
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'vis':[]}, {'imagename':''}, {'intent':''}, {'field':''}, {'spw':''}, {'spwsel_lsrk':{}}, {'spwsel_topo':[]}, {'uvrange':''}, {'gridder':''}, {'deconvolver':''}, {'nterms':2}, {'outframe':'LSRK'}, {'nchan':-1}, {'start':''}, {'phasecenter':''}, {'stokes':'I'}, {'restoringbeam':[]}, {'noise':'1.0Jy'}, {'npixels':0}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'vis':[]}, {'imagename':''}, {'intent':''}, {'field':''}, {'spw':''}, {'spwsel_lsrk':{}}, {'spwsel_topo':[]}, {'uvrange':''}, {'gridder':''}, {'deconvolver':''}, {'nterms':2}, {'outframe':'LSRK'}, {'nchan':-1}, {'start':''}, {'phasecenter':''}, {'stokes':'I'}, {'restoringbeam':[]}])}
        a['hm_masking'] = {
                    0:odict([{'value':'auto'}, {'hm_sidelobethreshold':-999.0}, {'hm_noisethreshold':-999.0}, {'hm_lownoisethreshold':-999.0}, {'hm_negativethreshold':-999.0}, {'hm_minbeamfrac':-999.0}, {'hm_growiterations':-999}, {'hm_dogrowprune':True}, {'hm_minpercentchange':-999.0}]), 
                    1:{'value':'centralregion'}, 
                    2:{'value':'psf'}, 
                    3:odict([{'value':'psfiter'}, {'maxncleans':10}]), 
                    4:odict([{'value':'manual'}, {'mask':''}]), 
                    5:{'value':'none'}, 
                    6:{'value':''}}
        a['hm_cleaning'] = {
                    0:odict([{'value':'manual'}, {'niter':5000}, {'threshold':0.0}]), 
                    1:odict([{'value':'sensitivity'}, {'tlimit':2.0}, {'niter':5000}]), 
                    2:odict([{'value':'rms'}, {'tlimit':2.0}, {'niter':5000}]), 
                    3:odict([{'value':'mask'}, {'masklimit':4}, {'threshold':0.0}])}
        a['specmode'] = {
                    0:{'value':''}, 
                    1:{'value':'mfs'}, 
                    2:{'value':'cont'}, 
                    3:odict([{'value':'cube'}, {'nchan':-1}, {'start':''}, {'outframe':''}])}
        a['weighting'] = {
                    0:odict([{'value':'briggs'}, {'robust':-999.0}, {'npixels':0}]), 
                    1:{'value':'natural'}, 
                    2:{'value':'uniform'}, 
                    3:odict([{'value':'briggsabs'}, {'robust':-999.0}, {'noise':'1.0Jy'}, {'npixels':0}]), 
                    4:odict([{'value':'superuniform'}, {'npixels':0}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_tclean', subkey=None):
        desc={'hif_tclean': 'Compute clean map',
               'vis': 'List of input MeasurementSets, \'\' for default',
               'imagename': 'Prefix for image filenames, \'\' for default',
               'intent': 'Set of data selection intents, \'\' for all',
               'field': 'Set of data selection field names or ids',
               'spw': 'Set of data selection spectral window/channels \'\' for all',
               'spwsel_lsrk': 'Dictionary of LSRK spw frequency selections, {} for automatic',
               'spwsel_topo': 'List of TOPO spw frequency selections per MS, [] for automatic',
               'uvrange': 'Set of uv ranges, \'\' for all',
               'specmode': 'Spectral gridding type (mfs, cont, cube, \'\' for default)',
               'gridder': 'Gridding options (standard, mosaic, \'\' for default)',
               'deconvolver': 'Minor cycle algorithm (hogbom, clark, mtmfs, \'\' for default)',
               'nterms': 'Number of terms when deconvolver=\'mtmfs\'',
               'outframe': 'velocity frame of output image (LSRK, \'\' for default)',
               'imsize': 'X and Y image size in pixels, single value same for both, \'\' for default',
               'cell': 'X and Y cell size(s), single value same for both, \'\' for default',
               'phasecenter': 'Image center (direction or field index), \'\' for default',
               'stokes': 'Stokes Planes to make',
               'nchan': 'Number of channels or planes in output image, -1 = all',
               'start': 'Start of output spectral dimension',
               'width': 'Width of output spectral channels, \'\' for default',
               'nbin': 'Channel binning factor, -1 for default.',
               'weighting': 'Type of weighting',
               'robust': 'Briggs weighting robustness parameter',
               'noise': 'Briggs weighting noise parameter',
               'npixels': 'Weighting algorithm parameter',
               'restoringbeam': 'Gaussian restoring beam, \'\' for default',
               'hm_masking': 'Pipeline heuristics masking option',
               'hm_sidelobethreshold': 'sidelobethreshold * the max sidelobe level',
               'hm_noisethreshold': 'noisethreshold * rms in residual image',
               'hm_lownoisethreshold': 'lownoisethreshold * rms in residual image',
               'hm_negativethreshold': 'negativethreshold * rms in residual image',
               'hm_minbeamfrac': 'minimum beam fraction for pruning',
               'hm_growiterations': 'number of binary dilation iterations for growing the mask',
               'hm_dogrowprune': 'Do pruning on the grow mask',
               'hm_minpercentchange': 'Mask size change threshold',
               'hm_cleaning': 'Pipeline clean control heuristics',
               'mask': 'User mask, \'\' for whole image',
               'niter': 'Maximum number of clean iterations',
               'threshold': 'Flux level to stop cleaning, must include units: \'1.0mJy\'',
               'tlimit': 'Times the sensitivity limit for cleaning',
               'masklimit': 'Times good mask pixels for cleaning',
               'maxncleans': 'Maximum number of clean task calls',
               'cleancontranges': 'Clean continuum frequency ranges in cubes',
               'parallel': 'Clean images using MPI cluster',
               'pipelinemode': 'The pipeline operating mode',
               'dryrun': 'Run the task (False) or display the command(True)',
               'acceptresults': 'Add the results to the pipeline context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['imagename']  = ''
        a['intent']  = ''
        a['field']  = ''
        a['spw']  = ''
        a['spwsel_lsrk']  = {}
        a['spwsel_topo']  = {}
        a['uvrange']  = ''
        a['specmode']  = ''
        a['gridder']  = ''
        a['deconvolver']  = ''
        a['nterms']  = 2
        a['outframe']  = ''
        a['imsize']  = []
        a['cell']  = ['']
        a['phasecenter']  = ''
        a['stokes']  = 'I'
        a['nchan']  = -1
        a['start']  = ''
        a['width']  = ''
        a['nbin']  = -1
        a['weighting']  = 'briggs'
        a['robust']  = -999.0
        a['noise']  = '1.0Jy'
        a['npixels']  = 0
        a['restoringbeam']  = ['']
        a['hm_masking']  = 'auto'
        a['hm_sidelobethreshold']  = -999.0
        a['hm_noisethreshold']  = -999.0
        a['hm_lownoisethreshold']  = -999.0
        a['hm_negativethreshold']  = -999.0
        a['hm_minbeamfrac']  = -999.0
        a['hm_growiterations']  = -999
        a['hm_dogrowprune']  = True
        a['hm_minpercentchange']  = -999.0
        a['hm_cleaning']  = 'rms'
        a['mask']  = []
        a['niter']  = 5000
        a['threshold']  = '0.0mJy'
        a['tlimit']  = 2.0
        a['masklimit']  = 4
        a['maxncleans']  = 1
        a['cleancontranges']  = False
        a['parallel']  = 'automatic'
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['vis'] = []
            a['imagename'] = ''
            a['intent'] = ''
            a['field'] = ''
            a['spw'] = ''
            a['spwsel_lsrk'] = {}
            a['spwsel_topo'] = []
            a['uvrange'] = ''
            a['gridder'] = ''
            a['deconvolver'] = ''
            a['nterms'] = 2
            a['outframe'] = 'LSRK'
            a['nchan'] = -1
            a['start'] = ''
            a['phasecenter'] = ''
            a['stokes'] = 'I'
            a['restoringbeam'] = []
            a['noise'] = '1.0Jy'
            a['npixels'] = 0
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['vis'] = []
            a['imagename'] = ''
            a['intent'] = ''
            a['field'] = ''
            a['spw'] = ''
            a['spwsel_lsrk'] = {}
            a['spwsel_topo'] = []
            a['uvrange'] = ''
            a['gridder'] = ''
            a['deconvolver'] = ''
            a['nterms'] = 2
            a['outframe'] = 'LSRK'
            a['nchan'] = -1
            a['start'] = ''
            a['phasecenter'] = ''
            a['stokes'] = 'I'
            a['restoringbeam'] = []

        if self.parameters['hm_masking']  == 'auto':
            a['hm_sidelobethreshold'] = -999.0
            a['hm_noisethreshold'] = -999.0
            a['hm_lownoisethreshold'] = -999.0
            a['hm_negativethreshold'] = -999.0
            a['hm_minbeamfrac'] = -999.0
            a['hm_growiterations'] = -999
            a['hm_dogrowprune'] = True
            a['hm_minpercentchange'] = -999.0

        if self.parameters['hm_masking']  == 'psfiter':
            a['maxncleans'] = 10

        if self.parameters['hm_masking']  == 'manual':
            a['mask'] = ''

        if self.parameters['hm_cleaning']  == 'manual':
            a['niter'] = 5000
            a['threshold'] = 0.0

        if self.parameters['hm_cleaning']  == 'sensitivity':
            a['tlimit'] = 2.0
            a['niter'] = 5000

        if self.parameters['hm_cleaning']  == 'rms':
            a['tlimit'] = 2.0
            a['niter'] = 5000

        if self.parameters['hm_cleaning']  == 'mask':
            a['masklimit'] = 4
            a['threshold'] = 0.0

        if self.parameters['specmode']  == 'cube':
            a['nchan'] = -1
            a['start'] = ''
            a['outframe'] = ''

        if self.parameters['weighting']  == 'briggs':
            a['robust'] = -999.0
            a['npixels'] = 0

        if self.parameters['weighting']  == 'briggsabs':
            a['robust'] = -999.0
            a['noise'] = '1.0Jy'
            a['npixels'] = 0

        if self.parameters['weighting']  == 'superuniform':
            a['npixels'] = 0

        if a.has_key(paramname) :
	      return a[paramname]
hif_tclean_cli = hif_tclean_cli_()
