#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_setmodels import hif_setmodels
class hif_setmodels_cli_:
    __name__ = "hif_setmodels"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_setmodels_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'reference':None, 'refintent':None, 'transfer':None, 'transintent':None, 'reffile':None, 'normfluxes':None, 'scalebychan':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, reference=None, refintent=None, transfer=None, transintent=None, reffile=None, normfluxes=None, scalebychan=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Set calibrator source models

	Detailed Description: 

Set calibrator source models

	Arguments :
		vis:	List of input MeasurementSets
		   Default Value: 

		reference:	Reference calibrator field name(s)
		   Default Value: 

		refintent:	Observing intent of reference fields
		   Default Value: AMPLITUDE

		transfer:	Transfer calibrator field name(s)
		   Default Value: 

		transintent:	Observing intent of transfer fields
		   Default Value: BANDPASS

		reffile:	Path to file with fluxes for non-solar system calibrators
		   Default Value: 

		normfluxes:	Normalize lookup fluxes
		   Default Value: True

		scalebychan:	Scale the flux density on a per channel basis or else on a per spw basis
		   Default Value: True

		pipelinemode:	The pipeline operating mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run the task (False) or display commands (True)
		   Default Value: False

		acceptresults:	Automatically accept results into context
		   Default Value: True

	Returns: void

	Example :


Derive flux densities for point source transfer calibrators using flux models
for reference calibrators.

---- pipeline parameter arguments which can be set in any pipeline mode
pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
    determines the values of all context defined pipeline inputs automatically.
    In interactive mode the user can set the pipeline context defined
    parameters manually.  In 'getinputs' mode the users can check the settings
    of all pipeline parameters without running the task.
    default: 'automatic'.

reffile -- The reference file containing a lookup table of point source models
    This file currently defaults to 'flux.csv' in the working directory. This
    file must conform to the standard pipeline 'flux.csv' format
    default: ''
    example: 'myfluxes.csv'

normfluxes --  Normalize the transfer field lookup fluxes to 1.0. The reference
    field fluxes are never normalized.
    default: True
    example: False

scalebychan -- Scale the flux density on a per channel basis or else on a per spw basis
    default: True
    example: False


---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- The list of input MeasurementSets. Defaults to the list of
    MeasurementSets specified in the pipeline context
    default: ''
    example: ['M32A.ms', 'M32B.ms']

reference -- A string containing a comma delimited list of  field names
    defining the reference calibrators. Defaults to field names with
    intent 'AMPLITUDE'.
    default: ''
    example: 'M82,3C273'

refintent -- A string containing a comma delimited list of intents 
    used to select the reference calibrators. Defaults to 'AMPLITUDE'.
    default: 'AMPLITUDE'. '' Means no sources.
    example: 'BANDPASS'

transfer -- A string containing a comma delimited list of  field names
    defining the transfer calibrators. Defaults to field names with
    intent ''.
    default: 'BANDPASS,PHASE,CHECK'
    example: 'J1328+041,J1206+30'

transintent -- A string containing a comma delimited list of intents 
    defining the transfer calibrators. Defaults to 'BANDPASS,PHASE,CHECK'.
    '' stands for no transfer sources.
    default: 'BANDPASS,PHASE,CHECK'
    example: 'PHASE'

--- pipeline task execution modes
dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: False

acceptresults -- Add the results of the task to the pipeline context (True) or
   reject them (False).
   default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned


Description

Set model fluxes values for calibrator reference and transfer sources using lookup
values. By default the reference sources are the flux calibrators and the transfer
sources are the bandpass, phase, and check source calibrators. Reference sources
which are also in the transfer source list are removed from the transfer source list.

Builtin lookup tables are sued to compute models for solar system object calibrators.
Point source models for other calibrators are provided in the reference file.
Normalize fluxes are computed for transfer sources if the normfluxes parameter is
set to True.

The reference file default to a file called 'flux.csv' in the current working
directory. This file is normal created in the importdata step. The file is in 
'csv' format and contains the following comma delimited columns.

vis,fieldid,spwid,I,Q,U,V,pix,comment

Issues

Examples

1. Set model fluxes for the flux, bandpass, phase, and check sources.

   hif_setmodels()


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_setmodels'
        self.__globals__['taskname'] = 'hif_setmodels'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['reference'] = reference = self.parameters['reference']
            myparams['refintent'] = refintent = self.parameters['refintent']
            myparams['transfer'] = transfer = self.parameters['transfer']
            myparams['transintent'] = transintent = self.parameters['transintent']
            myparams['reffile'] = reffile = self.parameters['reffile']
            myparams['normfluxes'] = normfluxes = self.parameters['normfluxes']
            myparams['scalebychan'] = scalebychan = self.parameters['scalebychan']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']


	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['reference'] = reference
        mytmp['refintent'] = refintent
        mytmp['transfer'] = transfer
        mytmp['transintent'] = transintent
        mytmp['reffile'] = reffile
        mytmp['normfluxes'] = normfluxes
        mytmp['scalebychan'] = scalebychan
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_setmodels.xml')

        casalog.origin('hif_setmodels')
	try :
          #if not trec.has_key('hif_setmodels') or not casac.casac.utils().verify(mytmp, trec['hif_setmodels']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_setmodels'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_setmodels', 'hif_setmodels.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_setmodels'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_setmodels(vis, reference, refintent, transfer, transintent, reffile, normfluxes, scalebychan, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_setmodels'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_setmodels', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['reffile']  = ''
        a['normfluxes']  = True
        a['scalebychan']  = True
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'vis':[]}, {'reference':''}, {'refintent':'AMPLITUDE'}, {'transfer':''}, {'transintent':'BANDPASS,PHASE,CHECK'}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'vis':[]}, {'reference':''}, {'refintent':'AMPLITUDE'}, {'transfer':'BANDPASS,PHASE,CHECK'}, {'transintent':''}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_setmodels', subkey=None):
        desc={'hif_setmodels': 'Set calibrator source models',
               'vis': 'List of input MeasurementSets',
               'reference': 'Reference calibrator field name(s)',
               'refintent': 'Observing intent of reference fields',
               'transfer': 'Transfer calibrator field name(s)',
               'transintent': 'Observing intent of transfer fields',
               'reffile': 'Path to file with fluxes for non-solar system calibrators',
               'normfluxes': 'Normalize lookup fluxes',
               'scalebychan': 'Scale the flux density on a per channel basis or else on a per spw basis',
               'pipelinemode': 'The pipeline operating mode',
               'dryrun': 'Run the task (False) or display commands (True)',
               'acceptresults': 'Automatically accept results into context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ''
        a['reference']  = ''
        a['refintent']  = 'AMPLITUDE'
        a['transfer']  = ''
        a['transintent']  = 'BANDPASS'
        a['reffile']  = ''
        a['normfluxes']  = True
        a['scalebychan']  = True
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['vis'] = []
            a['reference'] = ''
            a['refintent'] = 'AMPLITUDE'
            a['transfer'] = ''
            a['transintent'] = 'BANDPASS,PHASE,CHECK'
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['vis'] = []
            a['reference'] = ''
            a['refintent'] = 'AMPLITUDE'
            a['transfer'] = 'BANDPASS,PHASE,CHECK'
            a['transintent'] = ''

        if a.has_key(paramname) :
	      return a[paramname]
hif_setmodels_cli = hif_setmodels_cli_()
