#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_setjy import hif_setjy
class hif_setjy_cli_:
    __name__ = "hif_setjy"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_setjy_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'field':None, 'intent':None, 'spw':None, 'model':None, 'reffile':None, 'normfluxes':None, 'reffreq':None, 'fluxdensity':None, 'spix':None, 'scalebychan':None, 'standard':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, field=None, intent=None, spw=None, model=None, reffile=None, normfluxes=None, reffreq=None, fluxdensity=None, spix=None, scalebychan=None, standard=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Fill the model column with calibrated visibilities

	Detailed Description: 

Fills the model column with the model visibilities.

	Arguments :
		vis:	List of input MeasurementSets
		   Default Value: 

		field:	List of field names or ids
		   Default Value: 

		intent:	Observing intent of flux calibrators
		   Default Value: 

		spw:	List of spectral window ids
		   Default Value: 

		model:	File location for field model
		   Default Value: 

		reffile:	Path to file with fluxes for non-solar system calibrators
		   Default Value: 

		normfluxes:	Normalize lookup fluxes
		   Default Value: False

		reffreq:	Reference frequency for spix
		   Default Value: 1GHz

		fluxdensity:	Specified flux density [I,Q,U,V]; -1 will lookup values
		   Default Value: -1

		spix:	Spectral index of fluxdensity
		   Default Value: 0.0

		scalebychan:	Scale the flux density on a per channel basis or else on a per spw basis
		   Default Value: True

		standard:	Flux density standard
		   Default Value: 

		pipelinemode:	The pipeline operating mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run the task (False) or display the commands(True)
		   Default Value: False

		acceptresults:	Automatically accept results into the context
		   Default Value: True

	Returns: void

	Example :


Fills the model column with the model visibilities.

pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
   determines the values of all context defined pipeline inputs automatically.
   In interactive mode the user can set the pipeline context defined parameters
   manually.  In 'getinputs' mode the user can check the settings of all
   pipeline parameters without running the task.
   default: 'automatic'.

---- pipeline parameter arguments which can be set in any pipeline mode

fluxdensity -- Specified flux density [I,Q,U,V] in Jy. Uses [1,0,0,0]
    flux density for unrecognized sources, and standard flux densities for
    ones recognized by 'standard', including 3C286, 3C48, 3C147, and several
    planets, moons, and asteroids. 
    default=-1
    example: [3.06,0.0,0.0,0.0]

reffile -- Path to a file containing flux densities for calibrators unknown to
	CASA. Values given in this file take precedence over the CASA-derived values
	for all calibrators except solar system calibrators. By default the path is
	set to the CSV file created by h_importdata, consisting of catalogue fluxes 
	extracted from the ASDM.
	default: ''
	example: '', 'working/flux.csv'

spix -- Spectral index for fluxdensity S = fluxdensity * (freq/reffreq)**spix
    Only used if fluxdensity is being used. If fluxdensity is positive, and
    spix is nonzero, then reffreq must be set too.  It is applied in the same
    way to all polarizations, and does not account for Faraday rotation or
    depolarization.
    Default: 0

reffreq -- The reference frequency for spix, given with units. Provided
    to avoid division by zero. If the flux density is being scaled by spectral
    index, then reffreq must be set to whatever reference frequency is correct
    for the given fluxdensity and spix.  It cannot be determined from vis.  On
    the other hand, if spix is 0, then any positive frequency can be used and
    will be ignored.
    Default: '1GHz'
    Examples: '86.0GHz', '4.65e9Hz'


scalebychan -- This determines whether the fluxdensity set in the model is
    calculated on a per channel basis. If False then only one fluxdensity
    value is calculated per spw. 
    default: True

standard -- Flux density standard, used if fluxdensity[0] less than 0.0. The
    options are: 'Baars','Perley 90','Perley-Taylor 95', 'Perley-Taylor 99',
    'Perley-Butler 2010' and 'Butler-JPL-Horizons 2010'.
    default: 'Butler-JPL-Horizons 2012' for solar system object 
             'Perley-Butler 2010' otherwise


---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- The list of input MeasurementSets. Defaults to the list of
    MeasurementSets defined in the pipeline context.
    default: []
    example:

field -- The list of field names or field ids for which the models are
    to be set. Defaults to all fields with intent '*AMPLITUDE*'.
    default: ''
    example: '3C279', '3C279, M82'

intent -- A string containing a comma delimited list of intents against
    which the the selected fields are matched.  Defaults to all data
    with amplitude intent.
    default: ''
    example: '*AMPLITUDE*'

spw -- The list of spectral windows and channels for which bandpasses are
    computed. Defaults to all science spectral windows.
    default: ''
    example: '11,13,15,17'

model -- Model image for setting model visibilities. Not fully
    supported.
    default: ''
    example: see details in help for CASA setjy task


--- pipeline task execution modes
dryrun -- Run the commands (True) or generate the commands to be run but
       do not execute (False).
       default: True

acceptresults -- Add the results of the task to the pipeline context (True) or
       reject them (False).
       default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.

Description

Fills the model column with the model visibilities.

Issues

Support for the setjy spix parameter needs to be added.`

Examples

1. Set the model flux densities for all the amplitude calibrators.

    hif_setjy()


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_setjy'
        self.__globals__['taskname'] = 'hif_setjy'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['field'] = field = self.parameters['field']
            myparams['intent'] = intent = self.parameters['intent']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['model'] = model = self.parameters['model']
            myparams['reffile'] = reffile = self.parameters['reffile']
            myparams['normfluxes'] = normfluxes = self.parameters['normfluxes']
            myparams['reffreq'] = reffreq = self.parameters['reffreq']
            myparams['fluxdensity'] = fluxdensity = self.parameters['fluxdensity']
            myparams['spix'] = spix = self.parameters['spix']
            myparams['scalebychan'] = scalebychan = self.parameters['scalebychan']
            myparams['standard'] = standard = self.parameters['standard']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(vis)==str: vis=[vis]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['intent'] = intent
        mytmp['spw'] = spw
        mytmp['model'] = model
        mytmp['reffile'] = reffile
        mytmp['normfluxes'] = normfluxes
        mytmp['reffreq'] = reffreq
        mytmp['fluxdensity'] = fluxdensity
        mytmp['spix'] = spix
        mytmp['scalebychan'] = scalebychan
        mytmp['standard'] = standard
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_setjy.xml')

        casalog.origin('hif_setjy')
	try :
          #if not trec.has_key('hif_setjy') or not casac.casac.utils().verify(mytmp, trec['hif_setjy']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_setjy'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_setjy', 'hif_setjy.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_setjy'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_setjy(vis, field, intent, spw, model, reffile, normfluxes, reffreq, fluxdensity, spix, scalebychan, standard, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_setjy'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_setjy', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['fluxdensity']  = -1
        a['scalebychan']  = True
        a['standard']  = ''
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'vis':[]}, {'field':''}, {'intent':''}, {'spw':''}, {'reffile':''}, {'normfluxes':False}, {'model':''}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'vis':[]}, {'field':''}, {'intent':''}, {'spw':''}, {'reffile':''}, {'normfluxes':False}, {'model':''}])}
        a['fluxdensity'] = {
                    0:odict([{'notvalue':-1}, {'spix':0}, {'reffreq':'1GHz'}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_setjy', subkey=None):
        desc={'hif_setjy': 'Fill the model column with calibrated visibilities',
               'vis': 'List of input MeasurementSets',
               'field': 'List of field names or ids',
               'intent': 'Observing intent of flux calibrators',
               'spw': 'List of spectral window ids',
               'model': 'File location for field model',
               'reffile': 'Path to file with fluxes for non-solar system calibrators',
               'normfluxes': 'Normalize lookup fluxes',
               'reffreq': 'Reference frequency for spix',
               'fluxdensity': 'Specified flux density [I,Q,U,V]; -1 will lookup values',
               'spix': 'Spectral index of fluxdensity',
               'scalebychan': 'Scale the flux density on a per channel basis or else on a per spw basis',
               'standard': 'Flux density standard',
               'pipelinemode': 'The pipeline operating mode',
               'dryrun': 'Run the task (False) or display the commands(True)',
               'acceptresults': 'Automatically accept results into the context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['field']  = ''
        a['intent']  = ''
        a['spw']  = ''
        a['model']  = ''
        a['reffile']  = ''
        a['normfluxes']  = False
        a['reffreq']  = '1GHz'
        a['fluxdensity']  = -1
        a['spix']  = 0.0
        a['scalebychan']  = True
        a['standard']  = ''
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['vis'] = []
            a['field'] = ''
            a['intent'] = ''
            a['spw'] = ''
            a['reffile'] = ''
            a['normfluxes'] = False
            a['model'] = ''
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['vis'] = []
            a['field'] = ''
            a['intent'] = ''
            a['spw'] = ''
            a['reffile'] = ''
            a['normfluxes'] = False
            a['model'] = ''

        if self.parameters['fluxdensity']  != -1:
            a['spix'] = 0
            a['reffreq'] = '1GHz'

        if a.has_key(paramname) :
	      return a[paramname]
hif_setjy_cli = hif_setjy_cli_()
