#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_hif_setjy
def hif_setjy(vis=[''], field='', intent='', spw='', model='', reffile='', normfluxes=False, reffreq='1GHz', fluxdensity=-1, spix=0.0, scalebychan=True, standard='', pipelinemode='automatic', dryrun=False, acceptresults=True):

        """Fill the model column with calibrated visibilities

Fills the model column with the model visibilities.

pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
   determines the values of all context defined pipeline inputs automatically.
   In interactive mode the user can set the pipeline context defined parameters
   manually.  In 'getinputs' mode the user can check the settings of all
   pipeline parameters without running the task.
   default: 'automatic'.

---- pipeline parameter arguments which can be set in any pipeline mode

fluxdensity -- Specified flux density [I,Q,U,V] in Jy. Uses [1,0,0,0]
    flux density for unrecognized sources, and standard flux densities for
    ones recognized by 'standard', including 3C286, 3C48, 3C147, and several
    planets, moons, and asteroids. 
    default=-1
    example: [3.06,0.0,0.0,0.0]

reffile -- Path to a file containing flux densities for calibrators unknown to
	CASA. Values given in this file take precedence over the CASA-derived values
	for all calibrators except solar system calibrators. By default the path is
	set to the CSV file created by h_importdata, consisting of catalogue fluxes 
	extracted from the ASDM.
	default: ''
	example: '', 'working/flux.csv'

spix -- Spectral index for fluxdensity S = fluxdensity * (freq/reffreq)**spix
    Only used if fluxdensity is being used. If fluxdensity is positive, and
    spix is nonzero, then reffreq must be set too.  It is applied in the same
    way to all polarizations, and does not account for Faraday rotation or
    depolarization.
    Default: 0

reffreq -- The reference frequency for spix, given with units. Provided
    to avoid division by zero. If the flux density is being scaled by spectral
    index, then reffreq must be set to whatever reference frequency is correct
    for the given fluxdensity and spix.  It cannot be determined from vis.  On
    the other hand, if spix is 0, then any positive frequency can be used and
    will be ignored.
    Default: '1GHz'
    Examples: '86.0GHz', '4.65e9Hz'


scalebychan -- This determines whether the fluxdensity set in the model is
    calculated on a per channel basis. If False then only one fluxdensity
    value is calculated per spw. 
    default: True

standard -- Flux density standard, used if fluxdensity[0] less than 0.0. The
    options are: 'Baars','Perley 90','Perley-Taylor 95', 'Perley-Taylor 99',
    'Perley-Butler 2010' and 'Butler-JPL-Horizons 2010'.
    default: 'Butler-JPL-Horizons 2012' for solar system object 
             'Perley-Butler 2010' otherwise


---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- The list of input MeasurementSets. Defaults to the list of
    MeasurementSets defined in the pipeline context.
    default: []
    example:

field -- The list of field names or field ids for which the models are
    to be set. Defaults to all fields with intent '*AMPLITUDE*'.
    default: ''
    example: '3C279', '3C279, M82'

intent -- A string containing a comma delimited list of intents against
    which the the selected fields are matched.  Defaults to all data
    with amplitude intent.
    default: ''
    example: '*AMPLITUDE*'

spw -- The list of spectral windows and channels for which bandpasses are
    computed. Defaults to all science spectral windows.
    default: ''
    example: '11,13,15,17'

model -- Model image for setting model visibilities. Not fully
    supported.
    default: ''
    example: see details in help for CASA setjy task


--- pipeline task execution modes
dryrun -- Run the commands (True) or generate the commands to be run but
       do not execute (False).
       default: True

acceptresults -- Add the results of the task to the pipeline context (True) or
       reject them (False).
       default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.

Description

Fills the model column with the model visibilities.

Issues

Support for the setjy spix parameter needs to be added.`

Examples

1. Set the model flux densities for all the amplitude calibrators.

    hif_setjy()


        """
        if type(vis)==str: vis=[vis]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['field'] = field
        mytmp['intent'] = intent
        mytmp['spw'] = spw
        mytmp['model'] = model
        mytmp['reffile'] = reffile
        mytmp['normfluxes'] = normfluxes
        mytmp['reffreq'] = reffreq
        mytmp['fluxdensity'] = fluxdensity
        mytmp['spix'] = spix
        mytmp['scalebychan'] = scalebychan
        mytmp['standard'] = standard
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.utils().torecord(pathname+'hif_setjy.xml')

        casalog.origin('hif_setjy')
        if trec.has_key('hif_setjy') and casac.utils().verify(mytmp, trec['hif_setjy']) :
	    result = task_hif_setjy.hif_setjy(vis, field, intent, spw, model, reffile, normfluxes, reffreq, fluxdensity, spix, scalebychan, standard, pipelinemode, dryrun, acceptresults)

	else :
	  result = False
        return result
