#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_rawflagchans import hif_rawflagchans
class hif_rawflagchans_cli_:
    __name__ = "hif_rawflagchans"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_rawflagchans_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'spw':None, 'intent':None, 'flag_hilo':None, 'fhl_limit':None, 'fhl_minsample':None, 'flag_bad_quadrant':None, 'fbq_hilo_limit':None, 'fbq_antenna_frac_limit':None, 'fbq_baseline_frac_limit':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, spw=None, intent=None, flag_hilo=None, fhl_limit=None, fhl_minsample=None, flag_bad_quadrant=None, fbq_hilo_limit=None, fbq_antenna_frac_limit=None, fbq_baseline_frac_limit=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Flag deviant baseline/channels in raw data

	Detailed Description: 

Flag deviant baseline/channels in raw data.

	Arguments :
		vis:	List of input MeasurementSets
		   Default Value: 

		spw:	Set of data selection spectral windows, \'\' for all
		   Default Value: 

		intent:	Data intent to use in creating flagging view
		   Default Value: 

		flag_hilo:	True to flag outlier baseline/channels
		   Default Value: True

		fhl_limit:	Flag baseline/channels further from median than limit * MAD
		   Default Value: 20.0

		fhl_minsample:	Minimum number of points in sample
		   Default Value: 5

		flag_bad_quadrant:	True to flag bad quadrants in antennas
		   Default Value: True

		fbq_hilo_limit:	Note as \'suspect\' baseline/channels further from median than limit * MAD
		   Default Value: 8.0

		fbq_antenna_frac_limit:	Flag antenna quadrant if its fraction of \'suspect\' baseline/channels > limit
		   Default Value: 0.2

		fbq_baseline_frac_limit:	Flag baseline quadrant if its fraction of \'suspect\' baseline/channels > limit
		   Default Value: 1.0

		pipelinemode:	The pipeline operations mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run the task (False) or list commands(True)
		   Default Value: False

		acceptresults:	Automatically apply results to context
		   Default Value: True

	Returns: void

	Example :


hif_rawflagchans flags deviant baseline/channels in the raw data. 

The flagging views used are derived from the raw data for the specified 
intent - default is BANDPASS. 

Bad baseline/channels are flagged for all intents, not just the
one that is the basis of the flagging views.

For each spectral window the flagging view is a 2d image with axes 
'channel' and 'baseline'. The pixel for each channel,baseline is the 
time average of the underlying unflagged raw data.

The baseline axis is labeled by numbers of form id1.id2 where id1 and id2
are the IDs of the baseline antennas. Both id1 and id2 run over all 
antenna IDs in the observation. This means that each baseline is shown 
twice but has the benefit that 'bad' antennas are easily identified by 
eye.

Three flagging methods are available:

If parameter flag_hilo is set True then outliers from the median
of each flagging view will be flagged.

If parameter flag_bad_quadrant is set True then a simple 2 part 
test is used to check for bad antenna quadrants and/or bad baseline 
quadrants. Here a 'quadrant' is defined simply as one quarter of the
channel axis. The first part of the test is to note as 'suspect' those
points further from the view median than fbq_hilo_limit * MAD.
The second part is to flag entire antenna/quadrants if their
fraction of suspect points exceeds fbq_antenna_frac_limit. 
Failing that, entire baseline/quadrants may be flagged if their 
fraction of suspect points exceeds fbq_baseline_frac_limit. 
Suspect points are not flagged unless as part of a bad antenna or 
baseline quadrant. 

Keyword arguments:

pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
   determines the values of all context defined pipeline inputs automatically.
   In interactive mode the user can set the pipeline context defined parameters
   manually.  In 'getinputs' mode the user can check the settings of all
   pipeline parameters without running the task.
   default: 'automatic'.

---- pipeline parameter arguments which can be set in any pipeline mode

flag_hilo -- True to flag channel/baseline data further from the view
             median than fhl_limit * MAD.
    default: True

fhl_limit -- If flag_hilo is True then flag channel/baseline data
             further from the view median than fhl_limit * MAD.
    default: 20

fhl_minsample -- Do no flagging if the view median and MAD are derived
                 from fewer than fhl_minsample view pixels.
    default: 5

flag_bad_quadrant -- True to search for and flag bad antenna quadrants
                     and baseline quadrants. Here a /'quadrant/' is one 
                     quarter of the channel axis.
    default: True

fbq_hilo_limit -- If flag_bad_quadrant is True then channel/baselines
                  further from the the view median than fbq_hilo_limit
                  * MAD will be noted as 'suspect'. If there are 
                  enough of them to indicate that an antenna or baseline
                  quadrant is bad then all channel/baselines in that
                  quadrant will be flagged.
    default: 8.0

fbq_antenna_frac_limit -- If flag_bad_quadrant is True and the fraction
                          of suspect channel/baselines in a particular
                          antenna/quadrant exceeds fbq_antenna_frac_limit
                          then all data for that antenna/quadrant will
                          be flagged.
    default: 0.2

fbq_baseline_frac_limit -- If flag_bad_quadrant is True and the fraction
                           of suspect channel/baselines in a particular
                           baseline/quadrant exceeds fbq_baseline_frac_limit
                           then all data for that baseline/quadrant will
                           be flagged.
    default: 1.0 (i.e. no flagging)

---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- List of input MeasurementSets.
    default: [] - Use the MeasurementSets currently known to the pipeline
    context. 

intent -- A string containing the list of intents to be checked for antennas
    with deviant gains. The default is blank, which causes the task to select
    the 'BANDPASS' intent.
    default: ''
    example: '*BANDPASS*'

spw -- The list of spectral windows and channels to which the calibration
    will be applied. Defaults to all science windows in the pipeline
    context.
    default: '' 
    example: '17', '11, 15'

-- Pipeline task execution modes

dryrun -- Run the commands (True) or generate the commands to be run but
          do not execute (False).
    default: True

acceptresults -- This parameter has no effect. The Tsyscal file is already
                 in the pipeline context and is flagged in situ.

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.


Examples:

1. Flag bad quadrants and wild outliers, default method.

   hif_rawflagchans()
       equivalent to:
   hif_rawflagchans(flag_hilo=True, fhl_limit=20,
     flag_bad_quadrant=True, fbq_hilo_limit=8, 
     fbq_antenna_frac_limit=0.2, fbq_baseline_frac_limit=1.0)


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_rawflagchans'
        self.__globals__['taskname'] = 'hif_rawflagchans'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['intent'] = intent = self.parameters['intent']
            myparams['flag_hilo'] = flag_hilo = self.parameters['flag_hilo']
            myparams['fhl_limit'] = fhl_limit = self.parameters['fhl_limit']
            myparams['fhl_minsample'] = fhl_minsample = self.parameters['fhl_minsample']
            myparams['flag_bad_quadrant'] = flag_bad_quadrant = self.parameters['flag_bad_quadrant']
            myparams['fbq_hilo_limit'] = fbq_hilo_limit = self.parameters['fbq_hilo_limit']
            myparams['fbq_antenna_frac_limit'] = fbq_antenna_frac_limit = self.parameters['fbq_antenna_frac_limit']
            myparams['fbq_baseline_frac_limit'] = fbq_baseline_frac_limit = self.parameters['fbq_baseline_frac_limit']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(vis)==str: vis=[vis]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['spw'] = spw
        mytmp['intent'] = intent
        mytmp['flag_hilo'] = flag_hilo
        mytmp['fhl_limit'] = fhl_limit
        mytmp['fhl_minsample'] = fhl_minsample
        mytmp['flag_bad_quadrant'] = flag_bad_quadrant
        mytmp['fbq_hilo_limit'] = fbq_hilo_limit
        mytmp['fbq_antenna_frac_limit'] = fbq_antenna_frac_limit
        mytmp['fbq_baseline_frac_limit'] = fbq_baseline_frac_limit
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_rawflagchans.xml')

        casalog.origin('hif_rawflagchans')
	try :
          #if not trec.has_key('hif_rawflagchans') or not casac.casac.utils().verify(mytmp, trec['hif_rawflagchans']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_rawflagchans'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_rawflagchans', 'hif_rawflagchans.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_rawflagchans'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_rawflagchans(vis, spw, intent, flag_hilo, fhl_limit, fhl_minsample, flag_bad_quadrant, fbq_hilo_limit, fbq_antenna_frac_limit, fbq_baseline_frac_limit, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_rawflagchans'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_rawflagchans', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['flag_hilo']  = True
        a['flag_bad_quadrant']  = True
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'vis':[]}, {'intent':''}, {'spw':''}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'vis':[]}, {'intent':''}, {'spw':''}])}
        a['flag_hilo'] = {
                    0:odict([{'value':True}, {'fhl_limit':20.0}, {'fhl_minsample':5}]), 
                    1:{'value':False}}
        a['flag_bad_quadrant'] = {
                    0:odict([{'value':True}, {'fbq_hilo_limit':8.0}, {'fbq_antenna_frac_limit':0.2}, {'fbq_baseline_frac_limit':1.0}]), 
                    1:{'value':False}}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_rawflagchans', subkey=None):
        desc={'hif_rawflagchans': 'Flag deviant baseline/channels in raw data',
               'vis': 'List of input MeasurementSets',
               'spw': 'Set of data selection spectral windows, \'\' for all',
               'intent': 'Data intent to use in creating flagging view',
               'flag_hilo': 'True to flag outlier baseline/channels',
               'fhl_limit': 'Flag baseline/channels further from median than limit * MAD',
               'fhl_minsample': 'Minimum number of points in sample',
               'flag_bad_quadrant': 'True to flag bad quadrants in antennas',
               'fbq_hilo_limit': 'Note as \'suspect\' baseline/channels further from median than limit * MAD',
               'fbq_antenna_frac_limit': 'Flag antenna quadrant if its fraction of \'suspect\' baseline/channels > limit',
               'fbq_baseline_frac_limit': 'Flag baseline quadrant if its fraction of \'suspect\' baseline/channels > limit',
               'pipelinemode': 'The pipeline operations mode',
               'dryrun': 'Run the task (False) or list commands(True)',
               'acceptresults': 'Automatically apply results to context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['spw']  = ''
        a['intent']  = ''
        a['flag_hilo']  = True
        a['fhl_limit']  = 20.0
        a['fhl_minsample']  = 5
        a['flag_bad_quadrant']  = True
        a['fbq_hilo_limit']  = 8.0
        a['fbq_antenna_frac_limit']  = 0.2
        a['fbq_baseline_frac_limit']  = 1.0
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['vis'] = []
            a['intent'] = ''
            a['spw'] = ''
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['vis'] = []
            a['intent'] = ''
            a['spw'] = ''

        if self.parameters['flag_hilo']  == True:
            a['fhl_limit'] = 20.0
            a['fhl_minsample'] = 5

        if self.parameters['flag_bad_quadrant']  == True:
            a['fbq_hilo_limit'] = 8.0
            a['fbq_antenna_frac_limit'] = 0.2
            a['fbq_baseline_frac_limit'] = 1.0

        if a.has_key(paramname) :
	      return a[paramname]
hif_rawflagchans_cli = hif_rawflagchans_cli_()
