#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_makeimlist import hif_makeimlist
class hif_makeimlist_cli_:
    __name__ = "hif_makeimlist"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_makeimlist_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'imagename':None, 'intent':None, 'field':None, 'spw':None, 'contfile':None, 'linesfile':None, 'uvrange':None, 'specmode':None, 'outframe':None, 'hm_imsize':None, 'hm_cell':None, 'calmaxpix':None, 'phasecenter':None, 'nchan':None, 'start':None, 'width':None, 'nbins':None, 'clearlist':None, 'per_eb':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, imagename=None, intent=None, field=None, spw=None, contfile=None, linesfile=None, uvrange=None, specmode=None, outframe=None, hm_imsize=None, hm_cell=None, calmaxpix=None, phasecenter=None, nchan=None, start=None, width=None, nbins=None, clearlist=None, per_eb=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Compute list of clean images to be produced

	Detailed Description: 

Create a a list of images to be cleaned.

	Arguments :
		vis:	List of input MeasurementSets
		   Default Value: 

		imagename:	Prefix for output image names, \'\' for default.
		   Default Value: 

		intent:	Set of data selection intents
		   Default Value: TARGET

		field:	Set of data selection field names or ids, \'\' for all
		   Default Value: 

		spw:	Set of data selection spectral window/channels, \'\' for all
		   Default Value: 

		contfile:	Name of file with frequency ranges to use for continuum images.
		   Default Value: 

		linesfile:	Name of file with line frequency ranges to exclude for continuum images.
		   Default Value: 

		uvrange:	Set of data selection uv ranges, \'\' for all.
		   Default Value: 

		specmode:	Spectral gridding type (mfs, cont, cube, repBW, \'\' for default)
		   Default Value: 
		   Allowed Values:
				
				mfs
				cont
				cube
				repBW

		outframe:	velocity frame of output image (LSRK, \'\' for default)
		   Default Value: 
		   Allowed Values:
				
				LSRK

		hm_imsize:	Image X and Y size(s) in pixels or PB level (single fields), \'\' for default. Single value same for both. \'<number>pb\' for PB level.
		   Default Value: 

		hm_cell:	Image X and Y cell size(s) with units or pixels per beam, \'\' for default. Single value same for both. \'<number>ppb\' for pixels per beam.
		   Default Value: 

		calmaxpix:	Maximum X and Y size of calibrator images in pixels
		   Default Value: 300

		phasecenter:	Image center (direction or field index, \'\' for default)
		   Default Value: 

		nchan:	Number of channels, -1 = all 
		   Default Value: -1

		start:	Channel start, \'\' for default
		   Default Value: 

		width:	Channel width, \'\' for default.
		   Default Value: 

		nbins:	Channel binning factors per spw, \'\' for default.
		   Default Value: 

		clearlist:	Clear any previous target list
		   Default Value: False

		per_eb:	Make an image target per EB
		   Default Value: False

		pipelinemode:	The pipeline operating mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run the task (False) or display the command(True)
		   Default Value: False

		acceptresults:	Add the results to the pipeline context
		   Default Value: True

	Returns: void

	Example :


Create a list of images to be cleaned.

Keyword Arguments


pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
    determines the values of all context defined pipeline inputs automatically.
    In 'interactive' mode the user can set the pipeline context defined
    parameters manually.  In 'getinputs' mode the user can check the settings
    of all pipeline parameters without running the task.
    default: 'automatic'.

--- pipeline parameter arguments which can be set in any pipeline mode

specmode -- Frequency imaging mode, 'mfs', 'cont', 'cube', 'repBW'. \'\' defaults to
    'cube' if intent parameter includes 'TARGET' otherwise 'mfs'.
    default: ''
    example: 'mfs', 'cont', 'cube', 'repBW'
    example:
        specmode='mfs' produce one image per source and spw
        specmode='cont' produce one image per source and aggregate over all
             specified spws
        specmode='cube' produce an LSRK frequency cube, channels are specified
             in frequency
        specmode='repBW' produce an LSRK frequency cube at representative channel width

hm_cell -- Cell size (x, y)
    default '' Compute cell size based on the UV coverage of all the fields
         to be imaged and use a 5 pix per beam sampling.
         The pix per beam specification uses the above default cell size
         ('5ppb') and scales it accordingly.
    example: ['0.5arcsec', '0.5arcsec'] '3ppb'

hm_imsize -- Image X and Y size in pixels or PB level for single field. The
    explicit sizes must be even and divisible by 2,3,5,7 only.
    default: '' The default values are derived as follows:
         1. Determine phase center and spread of field centers around it. 
         2. Set the size of the image to cover the spread of field centers plus
            a border of width 0.75 * beam radius, to first null.
         3. Divide X and Y extents by cell size to arrive at the number of
	    pixels required. 
         The PB level setting for single fields leads to an imsize extending
         to the specified level plus 5% padding in all directions.
    example: [120, 120], '0.3pb'

calmaxpix -- Maximum image X or Y size in pixels if a calibrator is being 
    imaged ('PHASE', 'BANDPASS', 'AMPLITUDE' or 'FLUX').
    default: 300
    example: 300

width -- Output channel width.
    default: '' Difference in frequency between first 2 selected channels.
        for frequency mode images.
    example: '24.2kHz'
             'pilotimage' for 15 MHz / 8 channel heuristic

nbins -- Channel binning factors per spw
    default: '' Binning factors for each spw. Format: 'spw1:nb1,spw2:nb2,...'
             Optional wildcard: '*:nb'
    example: '9:2,11:4,13:2,15:8'
             '*:2'

---- pipeline context defined parameter arguments which can be set only in
     'interactive mode'

vis -- The list of input MeasurementSets. Defaults to the list of MeasurementSets
    specified in the h_init or hif_importdata sets.
    default '': use all MeasurementSets in the context 
    example: 'ngc5921.ms', ['ngc5921a.ms', ngc5921b.ms', 'ngc5921c.ms']

intent -- Select intents for which associated fields will be imaged.
    default: 'TARGET'
    example: 'PHASE,BANDPASS'

field -- Select fields to image. Use field name(s) NOT id(s). Mosaics
    are assumed to have common source / field names.  If intent is specified
    only fields with data matching the intent will be selected. The fields
    will be selected from MeasurementSets in 'vis'.
    default: '' Fields matching matching intent, one image per target source.
    example: '3C279', 'Centaurus*', '3C279,J1427-421'

spw -- Select spectral window/channels to image.
    default: '' Individual images will be computed for all science spectral
    windows.
    example: '9'

contfile -- Name of file with frequency ranges to use for continuum images.
    default: 'cont.dat'
    example: 'mycont.dat'

linesfile -- Name of file with line frequency ranges to exclude for continuum images.
    default: 'lines.dat'
    example: 'mylines.dat'

uvrange -- Select a set of uv ranges ro image.
    default: '' All uv data is included
    example: '0~1000klambda', ['0~100klambda', 100~1000klambda]

phasecenter -- Direction measure or field id of the image center.
    default: '' The default phase center is set to the mean of the field
        directions of all fields that are to be image together.
    example: 0, 'J2000 19h30m00 -40d00m00' 

nchan -- Total number of channels in the output image(s)
    default: -1 Selects enough channels to cover the data selected by
        spw consistent with start and width.
    example: 100

start -- First channel for frequency mode images.
    default '' Starts at first input channel of the spw.
    example: '22.3GHz'

clearlist -- Clear previous iamge target list.
    default False
    example: True

per_eb -- Make an image target per EB.
    default False
    example: True

--- pipeline task execution modes
dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: False

acceptresults -- Add the results of the task to the pipeline context (True) or
   reject them (False).
   default: True

Output

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.

Description

Generate a list of images to be cleaned. By default the list will include
one image per science target per spw. Calibrator targets can be selected
by setting appropriate values for intent.

By default the output image cellsize is set to the minimum cell size
consistent with the UV coverage.

By default the image size in pixels is set to values determined by the
cell size and the single dish beam size. If a calibrator is being
imaged (intents 'PHASE', 'BANDPASS', 'FLUX' or 'AMPLITUDE') then the
image dimensions are limited to 'calmaxpix' pixels.

By default science target images are cubes and calibrator target images
are single channel. Science target images may be mosaics or single fields.

Issues

TBD
Examples

1. Make a list of science target images to be cleaned, one image per science 
spw.

    hif_makeimlist()

2. Make a list of PHASE and BANDPASS calibrator targets to be imaged,
one image per science spw.

    hif_makeimlist(intent='PHASE,BANDPASS')

3. Make a list of PHASE calibrator images observed in spw 1, images limited to 
50 pixels on a side.

    hif_makeimlist(intent='PHASE',spw='1',calmaxpix=50)


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_makeimlist'
        self.__globals__['taskname'] = 'hif_makeimlist'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['imagename'] = imagename = self.parameters['imagename']
            myparams['intent'] = intent = self.parameters['intent']
            myparams['field'] = field = self.parameters['field']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['contfile'] = contfile = self.parameters['contfile']
            myparams['linesfile'] = linesfile = self.parameters['linesfile']
            myparams['uvrange'] = uvrange = self.parameters['uvrange']
            myparams['specmode'] = specmode = self.parameters['specmode']
            myparams['outframe'] = outframe = self.parameters['outframe']
            myparams['hm_imsize'] = hm_imsize = self.parameters['hm_imsize']
            myparams['hm_cell'] = hm_cell = self.parameters['hm_cell']
            myparams['calmaxpix'] = calmaxpix = self.parameters['calmaxpix']
            myparams['phasecenter'] = phasecenter = self.parameters['phasecenter']
            myparams['nchan'] = nchan = self.parameters['nchan']
            myparams['start'] = start = self.parameters['start']
            myparams['width'] = width = self.parameters['width']
            myparams['nbins'] = nbins = self.parameters['nbins']
            myparams['clearlist'] = clearlist = self.parameters['clearlist']
            myparams['per_eb'] = per_eb = self.parameters['per_eb']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(vis)==str: vis=[vis]
        if type(hm_imsize)==str: hm_imsize=[hm_imsize]
        if type(hm_cell)==str: hm_cell=[hm_cell]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['imagename'] = imagename
        mytmp['intent'] = intent
        mytmp['field'] = field
        mytmp['spw'] = spw
        mytmp['contfile'] = contfile
        mytmp['linesfile'] = linesfile
        mytmp['uvrange'] = uvrange
        mytmp['specmode'] = specmode
        mytmp['outframe'] = outframe
        mytmp['hm_imsize'] = hm_imsize
        mytmp['hm_cell'] = hm_cell
        mytmp['calmaxpix'] = calmaxpix
        mytmp['phasecenter'] = phasecenter
        mytmp['nchan'] = nchan
        mytmp['start'] = start
        mytmp['width'] = width
        mytmp['nbins'] = nbins
        mytmp['clearlist'] = clearlist
        mytmp['per_eb'] = per_eb
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_makeimlist.xml')

        casalog.origin('hif_makeimlist')
	try :
          #if not trec.has_key('hif_makeimlist') or not casac.casac.utils().verify(mytmp, trec['hif_makeimlist']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_makeimlist'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_makeimlist', 'hif_makeimlist.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_makeimlist'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_makeimlist(vis, imagename, intent, field, spw, contfile, linesfile, uvrange, specmode, outframe, hm_imsize, hm_cell, calmaxpix, phasecenter, nchan, start, width, nbins, clearlist, per_eb, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_makeimlist'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_makeimlist', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['specmode']  = ''
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'vis':[]}, {'imagename':''}, {'intent':''}, {'field':''}, {'spw':''}, {'contfile':''}, {'linesfile':''}, {'uvrange':''}, {'phasecenter':''}, {'start':''}, {'nchan':-1}, {'hm_imsize':[]}, {'hm_cell':[]}, {'width':''}, {'nbins':''}, {'clearlist':False}, {'per_eb':False}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'vis':[]}, {'imagename':''}, {'intent':''}, {'field':''}, {'spw':''}, {'contfile':''}, {'linesfile':''}, {'uvrange':''}, {'phasecenter':''}, {'start':''}, {'nchan':-1}])}
        a['specmode'] = {
                    0:{'value':''}, 
                    1:{'value':'mfs'}, 
                    2:odict([{'value':'cube'}, {'outframe':''}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_makeimlist', subkey=None):
        desc={'hif_makeimlist': 'Compute list of clean images to be produced',
               'vis': 'List of input MeasurementSets',
               'imagename': 'Prefix for output image names, \'\' for default.',
               'intent': 'Set of data selection intents',
               'field': 'Set of data selection field names or ids, \'\' for all',
               'spw': 'Set of data selection spectral window/channels, \'\' for all',
               'contfile': 'Name of file with frequency ranges to use for continuum images.',
               'linesfile': 'Name of file with line frequency ranges to exclude for continuum images.',
               'uvrange': 'Set of data selection uv ranges, \'\' for all.',
               'specmode': 'Spectral gridding type (mfs, cont, cube, repBW, \'\' for default)',
               'outframe': 'velocity frame of output image (LSRK, \'\' for default)',
               'hm_imsize': 'Image X and Y size(s) in pixels or PB level (single fields), \'\' for default. Single value same for both. \'<number>pb\' for PB level.',
               'hm_cell': 'Image X and Y cell size(s) with units or pixels per beam, \'\' for default. Single value same for both. \'<number>ppb\' for pixels per beam.',
               'calmaxpix': 'Maximum X and Y size of calibrator images in pixels',
               'phasecenter': 'Image center (direction or field index, \'\' for default)',
               'nchan': 'Number of channels, -1 = all ',
               'start': 'Channel start, \'\' for default',
               'width': 'Channel width, \'\' for default.',
               'nbins': 'Channel binning factors per spw, \'\' for default.',
               'clearlist': 'Clear any previous target list',
               'per_eb': 'Make an image target per EB',
               'pipelinemode': 'The pipeline operating mode',
               'dryrun': 'Run the task (False) or display the command(True)',
               'acceptresults': 'Add the results to the pipeline context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['imagename']  = ''
        a['intent']  = 'TARGET'
        a['field']  = ''
        a['spw']  = ''
        a['contfile']  = ''
        a['linesfile']  = ''
        a['uvrange']  = ''
        a['specmode']  = ''
        a['outframe']  = ''
        a['hm_imsize']  = ['']
        a['hm_cell']  = ['']
        a['calmaxpix']  = 300
        a['phasecenter']  = ''
        a['nchan']  = -1
        a['start']  = ''
        a['width']  = ''
        a['nbins']  = ''
        a['clearlist']  = False
        a['per_eb']  = False
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['vis'] = []
            a['imagename'] = ''
            a['intent'] = ''
            a['field'] = ''
            a['spw'] = ''
            a['contfile'] = ''
            a['linesfile'] = ''
            a['uvrange'] = ''
            a['phasecenter'] = ''
            a['start'] = ''
            a['nchan'] = -1
            a['hm_imsize'] = []
            a['hm_cell'] = []
            a['width'] = ''
            a['nbins'] = ''
            a['clearlist'] = False
            a['per_eb'] = False
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['vis'] = []
            a['imagename'] = ''
            a['intent'] = ''
            a['field'] = ''
            a['spw'] = ''
            a['contfile'] = ''
            a['linesfile'] = ''
            a['uvrange'] = ''
            a['phasecenter'] = ''
            a['start'] = ''
            a['nchan'] = -1

        if self.parameters['specmode']  == 'cube':
            a['outframe'] = ''

        if a.has_key(paramname) :
	      return a[paramname]
hif_makeimlist_cli = hif_makeimlist_cli_()
