#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_makeimages import hif_makeimages
class hif_makeimages_cli_:
    __name__ = "hif_makeimages"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_makeimages_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'target_list':None, 'weighting':None, 'robust':None, 'noise':None, 'npixels':None, 'hm_masking':None, 'hm_sidelobethreshold':None, 'hm_noisethreshold':None, 'hm_lownoisethreshold':None, 'hm_negativethreshold':None, 'hm_minbeamfrac':None, 'hm_growiterations':None, 'hm_dogrowprune':None, 'hm_minpercentchange':None, 'hm_cleaning':None, 'tlimit':None, 'masklimit':None, 'maxncleans':None, 'cleancontranges':None, 'parallel':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, target_list=None, weighting=None, robust=None, noise=None, npixels=None, hm_masking=None, hm_sidelobethreshold=None, hm_noisethreshold=None, hm_lownoisethreshold=None, hm_negativethreshold=None, hm_minbeamfrac=None, hm_growiterations=None, hm_dogrowprune=None, hm_minpercentchange=None, hm_cleaning=None, tlimit=None, masklimit=None, maxncleans=None, cleancontranges=None, parallel=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Compute clean map

	Detailed Description: 

Compute clean results from a list of specified targets.  

	Arguments :
		vis:	List of input MeasurementSets
		   Default Value: 

		target_list:	Dictionary specifying targets to be imaged; blank will read list from context
		   Default Value: {}

		weighting:	Weighting of uv (natural, uniform, briggs, ...)
		   Default Value: briggs
		   Allowed Values:
				briggs
				natural
				uniform
				superuniform
				briggsabs

		robust:	Briggs robustness parameter
		   Default Value: -999.0

		noise:	noise parameter for briggs abs mode weighting
		   Default Value: 1.0Jy

		npixels:	number of pixels for superuniform or briggs weighting
		   Default Value: 0

		hm_masking:	Pipeline heuristics masking option
		   Default Value: auto
		   Allowed Values:
				auto
				centralregion
				psf
				psfiter
				none
				manual
				

		hm_sidelobethreshold:	sidelobethreshold * the max sidelobe level
		   Default Value: -999.0

		hm_noisethreshold:	noisethreshold * rms in residual image
		   Default Value: -999.0

		hm_lownoisethreshold:	lownoisethreshold * rms in residual image
		   Default Value: -999.0

		hm_negativethreshold:	negativethreshold * rms in residual image
		   Default Value: -999.0

		hm_minbeamfrac:	Minimum beam fraction for pruning
		   Default Value: -999.0

		hm_growiterations:	Number of binary dilation iterations for growing the mask
		   Default Value: -999

		hm_dogrowprune:	Do pruning on the grow mask
		   Default Value: True

		hm_minpercentchange:	Mask size change threshold
		   Default Value: -999.0

		hm_cleaning:	Pipeline cleaning mode 
		   Default Value: 
		   Allowed Values:
				
				rms
				sensitivity
				timesmask
				manual

		tlimit:	Times the sensitivity limit for cleaning
		   Default Value: 2.0

		masklimit:	Times good mask pixels for cleaning
		   Default Value: 4

		maxncleans:	Maximum number of clean task calls
		   Default Value: 1

		cleancontranges:	Clean continuum frequency ranges in cubes
		   Default Value: False

		parallel:	Clean images using MPI cluster
		   Default Value: automatic
		   Allowed Values:
				automatic
				true
				false

		pipelinemode:	The pipeline operating mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run the task (False) or display the command(True)
		   Default Value: False

		acceptresults:	Add the results to the pipeline context
		   Default Value: True

	Returns: void

	Example :


Compute a cleaned image for a particular target source/intent and spectral
window.

Keyword arguments:

--- pipeline parameter arguments which can be set in any pipeline mode

pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
       determines the values of all context defined pipeline inputs
       automatically.  In interactive mode the user can set the pipeline
       context defined parameters manually.  In 'getinputs' mode the user
       can check the settings of all pipeline parameters without running
       the task.
       default: 'automatic'.


---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- The list of input MeasurementSets. Defaults to the list of 
    MeasurementSets specified in the h_init or hif_importdata sets.
    example: vis='ngc5921.ms'
             vis=['ngc5921a.ms', ngc5921b.ms', 'ngc5921c.ms']
    default: use all MeasurementSets in the context 

weighting -- Weighting to apply to visibilities:
             default='briggs'; example: weighting='uniform';
             Options: 'natural','uniform','briggs', 
                'superuniform','briggsabs','radial'

weighting_robust -- For weighting='briggs' and 'briggsabs'
                       default=-999.0; example: robust=0.7;
                       Options: -2.0 to 2.0; -2 (uniform)/+2 (natural)
                 
weighting_noise -- For weighting='briggsabs'
                       noise parameter to use for Briggs "abs" weighting
                       example noise='1.0mJy'

hm_masking -- Clean masking mode. Options are 'centralregion',
    'psf', 'psfiter', 'auto', 'manual' and 'none'
    default: 'auto'
    example: 'manual'

hm_sidelobethreshold -- sidelobethreshold * the max sidelobe level

hm_noisethreshold -- noisethreshold * rms in residual image

hm_lownoisethreshold -- lownoisethreshold * rms in residual image

hm_negativethreshold -- negativethreshold * rms in residual image

hm_minbeamfrac -- negativethreshold * rms in residual image

hm_growiterations -- Number of binary dilation iterations for growing the mask

hm_dogrowprune -- Do pruning on the grow mask

hm_minpercentchange -- Mask size change threshold

cleancontranges -- Clean continuum frequency ranges in cubes
                   default=False
                   Options: False, True

parallel -- use multiple CPU nodes to clean images
    default: \'automatic\'

--- pipeline task execution modes
dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: False

acceptresults -- Add the results of the task to the pipeline context (True) or
   reject them (False).
   default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.


Examples:


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_makeimages'
        self.__globals__['taskname'] = 'hif_makeimages'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['target_list'] = target_list = self.parameters['target_list']
            myparams['weighting'] = weighting = self.parameters['weighting']
            myparams['robust'] = robust = self.parameters['robust']
            myparams['noise'] = noise = self.parameters['noise']
            myparams['npixels'] = npixels = self.parameters['npixels']
            myparams['hm_masking'] = hm_masking = self.parameters['hm_masking']
            myparams['hm_sidelobethreshold'] = hm_sidelobethreshold = self.parameters['hm_sidelobethreshold']
            myparams['hm_noisethreshold'] = hm_noisethreshold = self.parameters['hm_noisethreshold']
            myparams['hm_lownoisethreshold'] = hm_lownoisethreshold = self.parameters['hm_lownoisethreshold']
            myparams['hm_negativethreshold'] = hm_negativethreshold = self.parameters['hm_negativethreshold']
            myparams['hm_minbeamfrac'] = hm_minbeamfrac = self.parameters['hm_minbeamfrac']
            myparams['hm_growiterations'] = hm_growiterations = self.parameters['hm_growiterations']
            myparams['hm_dogrowprune'] = hm_dogrowprune = self.parameters['hm_dogrowprune']
            myparams['hm_minpercentchange'] = hm_minpercentchange = self.parameters['hm_minpercentchange']
            myparams['hm_cleaning'] = hm_cleaning = self.parameters['hm_cleaning']
            myparams['tlimit'] = tlimit = self.parameters['tlimit']
            myparams['masklimit'] = masklimit = self.parameters['masklimit']
            myparams['maxncleans'] = maxncleans = self.parameters['maxncleans']
            myparams['cleancontranges'] = cleancontranges = self.parameters['cleancontranges']
            myparams['parallel'] = parallel = self.parameters['parallel']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(vis)==str: vis=[vis]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['target_list'] = target_list
        mytmp['weighting'] = weighting
        mytmp['robust'] = robust
        mytmp['noise'] = noise
        mytmp['npixels'] = npixels
        mytmp['hm_masking'] = hm_masking
        mytmp['hm_sidelobethreshold'] = hm_sidelobethreshold
        mytmp['hm_noisethreshold'] = hm_noisethreshold
        mytmp['hm_lownoisethreshold'] = hm_lownoisethreshold
        mytmp['hm_negativethreshold'] = hm_negativethreshold
        mytmp['hm_minbeamfrac'] = hm_minbeamfrac
        mytmp['hm_growiterations'] = hm_growiterations
        mytmp['hm_dogrowprune'] = hm_dogrowprune
        mytmp['hm_minpercentchange'] = hm_minpercentchange
        mytmp['hm_cleaning'] = hm_cleaning
        mytmp['tlimit'] = tlimit
        mytmp['masklimit'] = masklimit
        mytmp['maxncleans'] = maxncleans
        mytmp['cleancontranges'] = cleancontranges
        mytmp['parallel'] = parallel
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_makeimages.xml')

        casalog.origin('hif_makeimages')
	try :
          #if not trec.has_key('hif_makeimages') or not casac.casac.utils().verify(mytmp, trec['hif_makeimages']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_makeimages'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_makeimages', 'hif_makeimages.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_makeimages'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_makeimages(vis, target_list, weighting, robust, noise, npixels, hm_masking, hm_sidelobethreshold, hm_noisethreshold, hm_lownoisethreshold, hm_negativethreshold, hm_minbeamfrac, hm_growiterations, hm_dogrowprune, hm_minpercentchange, hm_cleaning, tlimit, masklimit, maxncleans, cleancontranges, parallel, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_makeimages'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_makeimages', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['weighting']  = 'briggs'
        a['hm_masking']  = 'auto'
        a['hm_cleaning']  = ''
        a['cleancontranges']  = False
        a['parallel']  = 'automatic'
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'vis':[]}, {'target_list':{}}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'vis':[]}, {'target_list':{}}])}
        a['hm_masking'] = {
                    0:odict([{'value':'auto'}, {'hm_sidelobethreshold':-999.0}, {'hm_noisethreshold':-999.0}, {'hm_lownoisethreshold':-999.0}, {'hm_negativethreshold':-999.0}, {'hm_minbeamfrac':-999.0}, {'hm_growiterations':-999}, {'hm_dogrowprune':True}, {'hm_minpercentchange':-999.0}]), 
                    1:{'value':'centralregion'}, 
                    2:{'value':'psf'}, 
                    3:odict([{'value':'psfiter'}, {'maxncleans':10}]), 
                    4:{'value':'none'}, 
                    5:{'value':''}}
        a['hm_cleaning'] = {
                    0:{'value':''}, 
                    1:odict([{'value':'rms'}, {'tlimit':2.0}]), 
                    2:odict([{'value':'sensitivity'}, {'tlimit':2.0}]), 
                    3:odict([{'value':'timesmask'}, {'masklimit':4}])}
        a['weighting'] = {
                    0:odict([{'value':'briggs'}, {'robust':-999.0}, {'npixels':0}]), 
                    1:{'value':'natural'}, 
                    2:{'value':'uniform'}, 
                    3:odict([{'value':'briggsabs'}, {'robust':-999.0}, {'noise':'1.0Jy'}, {'npixels':0}]), 
                    4:odict([{'value':'superuniform'}, {'npixels':0}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_makeimages', subkey=None):
        desc={'hif_makeimages': 'Compute clean map',
               'vis': 'List of input MeasurementSets',
               'target_list': 'Dictionary specifying targets to be imaged; blank will read list from context',
               'weighting': 'Weighting of uv (natural, uniform, briggs, ...)',
               'robust': 'Briggs robustness parameter',
               'noise': 'noise parameter for briggs abs mode weighting',
               'npixels': 'number of pixels for superuniform or briggs weighting',
               'hm_masking': 'Pipeline heuristics masking option',
               'hm_sidelobethreshold': 'sidelobethreshold * the max sidelobe level',
               'hm_noisethreshold': 'noisethreshold * rms in residual image',
               'hm_lownoisethreshold': 'lownoisethreshold * rms in residual image',
               'hm_negativethreshold': 'negativethreshold * rms in residual image',
               'hm_minbeamfrac': 'Minimum beam fraction for pruning',
               'hm_growiterations': 'Number of binary dilation iterations for growing the mask',
               'hm_dogrowprune': 'Do pruning on the grow mask',
               'hm_minpercentchange': 'Mask size change threshold',
               'hm_cleaning': 'Pipeline cleaning mode ',
               'tlimit': 'Times the sensitivity limit for cleaning',
               'masklimit': 'Times good mask pixels for cleaning',
               'maxncleans': 'Maximum number of clean task calls',
               'cleancontranges': 'Clean continuum frequency ranges in cubes',
               'parallel': 'Clean images using MPI cluster',
               'pipelinemode': 'The pipeline operating mode',
               'dryrun': 'Run the task (False) or display the command(True)',
               'acceptresults': 'Add the results to the pipeline context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['target_list']  = {}
        a['weighting']  = 'briggs'
        a['robust']  = -999.0
        a['noise']  = '1.0Jy'
        a['npixels']  = 0
        a['hm_masking']  = 'auto'
        a['hm_sidelobethreshold']  = -999.0
        a['hm_noisethreshold']  = -999.0
        a['hm_lownoisethreshold']  = -999.0
        a['hm_negativethreshold']  = -999.0
        a['hm_minbeamfrac']  = -999.0
        a['hm_growiterations']  = -999
        a['hm_dogrowprune']  = True
        a['hm_minpercentchange']  = -999.0
        a['hm_cleaning']  = ''
        a['tlimit']  = 2.0
        a['masklimit']  = 4
        a['maxncleans']  = 1
        a['cleancontranges']  = False
        a['parallel']  = 'automatic'
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['vis'] = []
            a['target_list'] = {}
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['vis'] = []
            a['target_list'] = {}

        if self.parameters['hm_masking']  == 'auto':
            a['hm_sidelobethreshold'] = -999.0
            a['hm_noisethreshold'] = -999.0
            a['hm_lownoisethreshold'] = -999.0
            a['hm_negativethreshold'] = -999.0
            a['hm_minbeamfrac'] = -999.0
            a['hm_growiterations'] = -999
            a['hm_dogrowprune'] = True
            a['hm_minpercentchange'] = -999.0

        if self.parameters['hm_masking']  == 'psfiter':
            a['maxncleans'] = 10

        if self.parameters['hm_cleaning']  == 'rms':
            a['tlimit'] = 2.0

        if self.parameters['hm_cleaning']  == 'sensitivity':
            a['tlimit'] = 2.0

        if self.parameters['hm_cleaning']  == 'timesmask':
            a['masklimit'] = 4

        if self.parameters['weighting']  == 'briggs':
            a['robust'] = -999.0
            a['npixels'] = 0

        if self.parameters['weighting']  == 'briggsabs':
            a['robust'] = -999.0
            a['noise'] = '1.0Jy'
            a['npixels'] = 0

        if self.parameters['weighting']  == 'superuniform':
            a['npixels'] = 0

        if a.has_key(paramname) :
	      return a[paramname]
hif_makeimages_cli = hif_makeimages_cli_()
