#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_lowgainflag import hif_lowgainflag
class hif_lowgainflag_cli_:
    __name__ = "hif_lowgainflag"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_lowgainflag_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'intent':None, 'spw':None, 'refant':None, 'flag_nmedian':None, 'fnm_lo_limit':None, 'fnm_hi_limit':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, intent=None, spw=None, refant=None, flag_nmedian=None, fnm_lo_limit=None, fnm_hi_limit=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Flag antennas with low or high gain

	Detailed Description: 

Flag antennas with low or high gain.

	Arguments :
		vis:	List of input MeasurementSets
		   Default Value: 

		intent:	Data intent whose gains are to checked
		   Default Value: 

		spw:	Spectral window ids whose gains are to be checked
		   Default Value: 

		refant:	Reference antenna names
		   Default Value: 

		flag_nmedian:	True to flag values outside range [fnm_lo_limit * median, fnm_hi_limit*nmedian]
		   Default Value: True

		fnm_lo_limit:	Flag values lower than fnm_lo_limit * median
		   Default Value: 0.7

		fnm_hi_limit:	Flag values higher than fnm_hi_limit * median
		   Default Value: 1.3

		pipelinemode:	The pipeline operations mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run the task (False) or list commands(True)
		   Default Value: False

		acceptresults:	Automatically apply results to context
		   Default Value: True

	Returns: void

	Example :


hif_lowgainflag flags data for antennas with unusually low or high gains.

Keyword arguments:

pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
   determines the values of all context defined pipeline inputs automatically.
   In interactive mode the user can set the pipeline context defined parameters
   manually.  In 'getinputs' mode the user can check the settings of all
   pipeline parameters without running the task.
   default: 'automatic'.

---- pipeline parameter arguments which can be set in any pipeline mode

flag_nmedian -- True to flag figures of merit greater than 
                fnm_hi_limit * median or lower than fnm_lo_limit * median.
    default True

fnm_lo_limit -- Points lower than fnm_lo_limit * median are flagged.
    default 0.7

fnm_hi_limit -- Points greater than fnm_hi_limit * median are flagged.
    default 1.3

---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- List of input MeasurementSets.
    default: [] - Use the MeasurementSets currently known to the pipeline
    context. 

intent -- A string containing the list of intents to be checked for antennas
    with deviant gains. The default is blank, which causes the task to select
    the 'BANDPASS' intent.
    default: ''
    example: '*BANDPASS*'

spw -- The list of spectral windows and channels to which the calibration
    will be applied. Defaults to all science windows in the pipeline
    context.
    default: '' 
    example: '17', '11, 15'

refant -- A string containing a prioritized list of reference antenna name(s)
    to be used to produce the gain table. Defaults to the value(s) stored in 
    the pipeline context. If undefined in the pipeline context defaults to the
    CASA reference antenna naming scheme.
    default: ''
    example: refant='DV01', refant='DV06,DV07'

-- Pipeline task execution modes

dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: True

acceptresults -- Add the results of the task to the pipeline context (True) or
   reject them (False).
   default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.

Description
Deviant antennas are detected by analysis of a view showing their calibration 
gains. This view is a list of 2D images with axes 'Time' and
'Antenna'; there is one image for each spectral window and intent.
A flagcmd to flag all data for an antenna will be generated by any gain that 
is outside the range [fnm_lo_limit * median, fnm_hi_limit * median].


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_lowgainflag'
        self.__globals__['taskname'] = 'hif_lowgainflag'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['intent'] = intent = self.parameters['intent']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['refant'] = refant = self.parameters['refant']
            myparams['flag_nmedian'] = flag_nmedian = self.parameters['flag_nmedian']
            myparams['fnm_lo_limit'] = fnm_lo_limit = self.parameters['fnm_lo_limit']
            myparams['fnm_hi_limit'] = fnm_hi_limit = self.parameters['fnm_hi_limit']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(vis)==str: vis=[vis]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['intent'] = intent
        mytmp['spw'] = spw
        mytmp['refant'] = refant
        mytmp['flag_nmedian'] = flag_nmedian
        mytmp['fnm_lo_limit'] = fnm_lo_limit
        mytmp['fnm_hi_limit'] = fnm_hi_limit
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_lowgainflag.xml')

        casalog.origin('hif_lowgainflag')
	try :
          #if not trec.has_key('hif_lowgainflag') or not casac.casac.utils().verify(mytmp, trec['hif_lowgainflag']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_lowgainflag'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_lowgainflag', 'hif_lowgainflag.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_lowgainflag'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_lowgainflag(vis, intent, spw, refant, flag_nmedian, fnm_lo_limit, fnm_hi_limit, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_lowgainflag'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_lowgainflag', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['flag_nmedian']  = True
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'vis':[]}, {'intent':''}, {'spw':''}, {'refant':''}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'vis':[]}, {'intent':''}, {'spw':''}, {'refant':''}])}
        a['flag_nmedian'] = {
                    0:odict([{'value':True}, {'fnm_lo_limit':0.7}, {'fnm_hi_limit':1.3}]), 
                    1:{'value':False}}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_lowgainflag', subkey=None):
        desc={'hif_lowgainflag': 'Flag antennas with low or high gain',
               'vis': 'List of input MeasurementSets',
               'intent': 'Data intent whose gains are to checked',
               'spw': 'Spectral window ids whose gains are to be checked',
               'refant': 'Reference antenna names',
               'flag_nmedian': 'True to flag values outside range [fnm_lo_limit * median, fnm_hi_limit*nmedian]',
               'fnm_lo_limit': 'Flag values lower than fnm_lo_limit * median',
               'fnm_hi_limit': 'Flag values higher than fnm_hi_limit * median',
               'pipelinemode': 'The pipeline operations mode',
               'dryrun': 'Run the task (False) or list commands(True)',
               'acceptresults': 'Automatically apply results to context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['intent']  = ''
        a['spw']  = ''
        a['refant']  = ''
        a['flag_nmedian']  = True
        a['fnm_lo_limit']  = 0.7
        a['fnm_hi_limit']  = 1.3
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['vis'] = []
            a['intent'] = ''
            a['spw'] = ''
            a['refant'] = ''
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['vis'] = []
            a['intent'] = ''
            a['spw'] = ''
            a['refant'] = ''

        if self.parameters['flag_nmedian']  == True:
            a['fnm_lo_limit'] = 0.7
            a['fnm_hi_limit'] = 1.3

        if a.has_key(paramname) :
	      return a[paramname]
hif_lowgainflag_cli = hif_lowgainflag_cli_()
