#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_hif_lowgainflag
def hif_lowgainflag(vis=[''], intent='', spw='', refant='', flag_nmedian=True, fnm_lo_limit=0.7, fnm_hi_limit=1.3, pipelinemode='automatic', dryrun=False, acceptresults=True):

        """Flag antennas with low or high gain

hif_lowgainflag flags data for antennas with unusually low or high gains.

Keyword arguments:

pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
   determines the values of all context defined pipeline inputs automatically.
   In interactive mode the user can set the pipeline context defined parameters
   manually.  In 'getinputs' mode the user can check the settings of all
   pipeline parameters without running the task.
   default: 'automatic'.

---- pipeline parameter arguments which can be set in any pipeline mode

flag_nmedian -- True to flag figures of merit greater than 
                fnm_hi_limit * median or lower than fnm_lo_limit * median.
    default True

fnm_lo_limit -- Points lower than fnm_lo_limit * median are flagged.
    default 0.7

fnm_hi_limit -- Points greater than fnm_hi_limit * median are flagged.
    default 1.3

---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- List of input MeasurementSets.
    default: [] - Use the MeasurementSets currently known to the pipeline
    context. 

intent -- A string containing the list of intents to be checked for antennas
    with deviant gains. The default is blank, which causes the task to select
    the 'BANDPASS' intent.
    default: ''
    example: '*BANDPASS*'

spw -- The list of spectral windows and channels to which the calibration
    will be applied. Defaults to all science windows in the pipeline
    context.
    default: '' 
    example: '17', '11, 15'

refant -- A string containing a prioritized list of reference antenna name(s)
    to be used to produce the gain table. Defaults to the value(s) stored in 
    the pipeline context. If undefined in the pipeline context defaults to the
    CASA reference antenna naming scheme.
    default: ''
    example: refant='DV01', refant='DV06,DV07'

-- Pipeline task execution modes

dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: True

acceptresults -- Add the results of the task to the pipeline context (True) or
   reject them (False).
   default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.

Description
Deviant antennas are detected by analysis of a view showing their calibration 
gains. This view is a list of 2D images with axes 'Time' and
'Antenna'; there is one image for each spectral window and intent.
A flagcmd to flag all data for an antenna will be generated by any gain that 
is outside the range [fnm_lo_limit * median, fnm_hi_limit * median].


        """
        if type(vis)==str: vis=[vis]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['intent'] = intent
        mytmp['spw'] = spw
        mytmp['refant'] = refant
        mytmp['flag_nmedian'] = flag_nmedian
        mytmp['fnm_lo_limit'] = fnm_lo_limit
        mytmp['fnm_hi_limit'] = fnm_hi_limit
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.utils().torecord(pathname+'hif_lowgainflag.xml')

        casalog.origin('hif_lowgainflag')
        if trec.has_key('hif_lowgainflag') and casac.utils().verify(mytmp, trec['hif_lowgainflag']) :
	    result = task_hif_lowgainflag.hif_lowgainflag(vis, intent, spw, refant, flag_nmedian, fnm_lo_limit, fnm_hi_limit, pipelinemode, dryrun, acceptresults)

	else :
	  result = False
        return result
