#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_gainflag import hif_gainflag
class hif_gainflag_cli_:
    __name__ = "hif_gainflag"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_gainflag_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'intent':None, 'spw':None, 'refant':None, 'flag_mediandeviant':None, 'fmeddev_limit':None, 'flag_rmsdeviant':None, 'frmsdev_limit':None, 'flag_nrmsdeviant':None, 'fnrmsdev_limit':None, 'metric_order':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, intent=None, spw=None, refant=None, flag_mediandeviant=None, fmeddev_limit=None, flag_rmsdeviant=None, frmsdev_limit=None, flag_nrmsdeviant=None, fnrmsdev_limit=None, metric_order=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Flag antennas with deviant gain

	Detailed Description: 

Flag antennas with deviant gain

	Arguments :
		vis:	List of input MeasurementSets
		   Default Value: 

		intent:	Data intent whose gains are to checked
		   Default Value: 

		spw:	Spectral window ids whose gains are to be checked
		   Default Value: 

		refant:	Reference antenna names
		   Default Value: 

		flag_mediandeviant:	True to flag antennas with deviant median gains
		   Default Value: False

		fmeddev_limit:	Flag antennas with \'mediandeviant\' metric above fmeddev_limit
		   Default Value: 3.0

		flag_rmsdeviant:	True to flag antennas with deviant gain rms
		   Default Value: False

		frmsdev_limit:	Flag antennas with \'rmsdeviant\' metric above frmsdev_limit
		   Default Value: 8.0

		flag_nrmsdeviant:	True to flag antennas with deviant normalised gain rms
		   Default Value: True

		fnrmsdev_limit:	Flag antennas with \'nrmsdeviant\' metric above fnrmsdev_limit
		   Default Value: 6.0

		metric_order:	Order in which the flagging metrics are evaluated
		   Default Value: mediandeviant, rmsdeviant, nrmsdeviant

		pipelinemode:	The pipeline operations mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run the task (False) or list commands(True)
		   Default Value: False

		acceptresults:	Automatically apply results to context
		   Default Value: True

	Returns: void

	Example :


hif_gainflag flags data for antennas with deviant median gains and/or high 
gain rms.

Keyword arguments:

pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
   determines the values of all context defined pipeline inputs automatically.
   In interactive mode the user can set the pipeline context defined parameters
   manually.  In 'getinputs' mode the user can check the settings of all
   pipeline parameters without running the task.
   default: 'automatic'.

---- pipeline parameter arguments which can be set in any pipeline mode

flag_mediandeviant -- True to flag antennas with deviant median gain, 
    calculated as:
    
    abs( median(antenna) - median(all antennas) ) / MAD(all antennas) 
      > fmeddev_limit
    
    default False

fmeddev_limit -- Flag antennas with \'mediandeviant\' metric larger than 
    fmeddev_limit.
    default: 3.0

flag_rmsdeviant -- True to flag antennas with deviant gain rms, calculated as:

    stdev(antenna) / MAD(all antennas) > frmsdev_limit

    default: False

frmsdev_limit -- Flag antennas with 'rmsdeviant' metric larger than 
    frmsdev_limit.
    default: 8.0

flag_nrmsdeviant -- True to flag antennas with deviant normalised gain rms, 
    calculated as:

    deviation (ant_i) = ( sm(ant_i) - med_sm_allant ) / sigma_sm_allant
    
    where: 
     sm(ant_i) = sigma(ant_i) / median(ant_i)
     sigma_sm_allant = 1.4826 * mad({sm(ant_1), sm(ant_2), .., sm(ant_nants)})
     med_sm_allant = median( {sm(ant_1), sm(ant_2), ..., sm(ant_nants)} )

    default: True

fnrmsdev_limit -- Flag antennas with 'nrmsdeviant' metric larger than 
    fnrmsdev_limit.
    default: 6.0

metric_order -- Order in which the flagging metrics are evaluated.
    default: 'mediandeviant, rmsdeviant, nrmsdeviant'

---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- List of input MeasurementSets.
    default: [] - Use the MeasurementSets currently known to the pipeline
    context. 

intent -- A string containing the list of intents to be checked for antennas
    with deviant gains. The default is blank, which causes the task to select
    the 'BANDPASS' intent.
    default: ''
    example: '*BANDPASS*'

spw -- The list of spectral windows and channels to which the calibration
    will be applied. Defaults to all science windows in the pipeline
    context.
    default: '' 
    example: '17', '11, 15'

refant -- A string containing a prioritized list of reference antenna name(s)
    to be used to produce the gain table. Defaults to the value(s) stored in 
    the pipeline context. If undefined in the pipeline context defaults to the
    CASA reference antenna naming scheme.
    default: ''
    example: refant='DV01', refant='DV06,DV07'

-- Pipeline task execution modes

dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: True

acceptresults -- Add the results of the task to the pipeline context (True) or
   reject them (False).
   default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.

Description
Deviant antennas are detected by analysis of a view showing their calibration 
gains. Three flagging metrics are available (mediandeviant, rmsdeviant, 
nrmsdeviant) and a flagging view is created for each metric that has been 
enabled. Each view is a list of 2D images with axes 'Time' and 'Antenna'; 
there is one image for each spectral window and intent. If any of the flagging
metrics exceeds their corresponding limit (fmeddev_limit, frmsdev_limit, 
fnrmsdev_limit) for a given antenna in a given spw, then all data for that 
antenna and for all spws within the same baseband will be flagged with a 
flagcmd.

The following heuristics are used for the flagging metrics:

   mediandeviant:
     abs( median(antenna) - median(all antennas) ) / MAD(all antennas) 
       > fmeddev_limit

   rmsdeviant:
     stdev(antenna) / MAD(all antennas) > frmsdev_limit

   nrmsdeviant:
    deviation (ant_i) = ( sm(ant_i) - med_sm_allant ) / sigma_sm_allant
    with: 
     sm(ant_i) = sigma(ant_i) / median(ant_i)
     sigma_sm_allant = 1.4826 * mad({sm(ant_1), sm(ant_2), .., sm(ant_nants)})
     med_sm_allant = median( {sm(ant_1), sm(ant_2), ..., sm(ant_nants)} )
     
   where MAD is the median absolute deviation from the median.


        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_gainflag'
        self.__globals__['taskname'] = 'hif_gainflag'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['intent'] = intent = self.parameters['intent']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['refant'] = refant = self.parameters['refant']
            myparams['flag_mediandeviant'] = flag_mediandeviant = self.parameters['flag_mediandeviant']
            myparams['fmeddev_limit'] = fmeddev_limit = self.parameters['fmeddev_limit']
            myparams['flag_rmsdeviant'] = flag_rmsdeviant = self.parameters['flag_rmsdeviant']
            myparams['frmsdev_limit'] = frmsdev_limit = self.parameters['frmsdev_limit']
            myparams['flag_nrmsdeviant'] = flag_nrmsdeviant = self.parameters['flag_nrmsdeviant']
            myparams['fnrmsdev_limit'] = fnrmsdev_limit = self.parameters['fnrmsdev_limit']
            myparams['metric_order'] = metric_order = self.parameters['metric_order']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(vis)==str: vis=[vis]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['intent'] = intent
        mytmp['spw'] = spw
        mytmp['refant'] = refant
        mytmp['flag_mediandeviant'] = flag_mediandeviant
        mytmp['fmeddev_limit'] = fmeddev_limit
        mytmp['flag_rmsdeviant'] = flag_rmsdeviant
        mytmp['frmsdev_limit'] = frmsdev_limit
        mytmp['flag_nrmsdeviant'] = flag_nrmsdeviant
        mytmp['fnrmsdev_limit'] = fnrmsdev_limit
        mytmp['metric_order'] = metric_order
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_gainflag.xml')

        casalog.origin('hif_gainflag')
	try :
          #if not trec.has_key('hif_gainflag') or not casac.casac.utils().verify(mytmp, trec['hif_gainflag']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_gainflag'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_gainflag', 'hif_gainflag.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_gainflag'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_gainflag(vis, intent, spw, refant, flag_mediandeviant, fmeddev_limit, flag_rmsdeviant, frmsdev_limit, flag_nrmsdeviant, fnrmsdev_limit, metric_order, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_gainflag'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_gainflag', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['flag_mediandeviant']  = False
        a['flag_rmsdeviant']  = False
        a['flag_nrmsdeviant']  = True
        a['metric_order']  = 'mediandeviant, rmsdeviant, nrmsdeviant'
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'vis':[]}, {'intent':''}, {'spw':''}, {'refant':''}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'vis':[]}, {'intent':''}, {'spw':''}, {'refant':''}])}
        a['flag_mediandeviant'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'fmeddev_limit':3.0}])}
        a['flag_rmsdeviant'] = {
                    0:{'value':False}, 
                    1:odict([{'value':True}, {'frmsdev_limit':8.0}])}
        a['flag_nrmsdeviant'] = {
                    0:odict([{'value':True}, {'fnrmsdev_limit':6.0}]), 
                    1:{'value':False}}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_gainflag', subkey=None):
        desc={'hif_gainflag': 'Flag antennas with deviant gain',
               'vis': 'List of input MeasurementSets',
               'intent': 'Data intent whose gains are to checked',
               'spw': 'Spectral window ids whose gains are to be checked',
               'refant': 'Reference antenna names',
               'flag_mediandeviant': 'True to flag antennas with deviant median gains',
               'fmeddev_limit': 'Flag antennas with \'mediandeviant\' metric above fmeddev_limit',
               'flag_rmsdeviant': 'True to flag antennas with deviant gain rms',
               'frmsdev_limit': 'Flag antennas with \'rmsdeviant\' metric above frmsdev_limit',
               'flag_nrmsdeviant': 'True to flag antennas with deviant normalised gain rms',
               'fnrmsdev_limit': 'Flag antennas with \'nrmsdeviant\' metric above fnrmsdev_limit',
               'metric_order': 'Order in which the flagging metrics are evaluated',
               'pipelinemode': 'The pipeline operations mode',
               'dryrun': 'Run the task (False) or list commands(True)',
               'acceptresults': 'Automatically apply results to context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['intent']  = ''
        a['spw']  = ''
        a['refant']  = ''
        a['flag_mediandeviant']  = False
        a['fmeddev_limit']  = 3.0
        a['flag_rmsdeviant']  = False
        a['frmsdev_limit']  = 8.0
        a['flag_nrmsdeviant']  = True
        a['fnrmsdev_limit']  = 6.0
        a['metric_order']  = 'mediandeviant, rmsdeviant, nrmsdeviant'
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['vis'] = []
            a['intent'] = ''
            a['spw'] = ''
            a['refant'] = ''
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['vis'] = []
            a['intent'] = ''
            a['spw'] = ''
            a['refant'] = ''

        if self.parameters['flag_mediandeviant']  == True:
            a['fmeddev_limit'] = 3.0

        if self.parameters['flag_rmsdeviant']  == True:
            a['frmsdev_limit'] = 8.0

        if self.parameters['flag_nrmsdeviant']  == True:
            a['fnrmsdev_limit'] = 6.0

        if a.has_key(paramname) :
	      return a[paramname]
hif_gainflag_cli = hif_gainflag_cli_()
