#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_gaincal import hif_gaincal
class hif_gaincal_cli_:
    __name__ = "hif_gaincal"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_gaincal_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'vis':None, 'caltable':None, 'field':None, 'intent':None, 'spw':None, 'antenna':None, 'hm_gaintype':None, 'calmode':None, 'solint':None, 'combine':None, 'refant':None, 'solnorm':None, 'minblperant':None, 'minsnr':None, 'smodel':None, 'splinetime':None, 'npointaver':None, 'phasewrap':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, vis=None, caltable=None, field=None, intent=None, spw=None, antenna=None, hm_gaintype=None, calmode=None, solint=None, combine=None, refant=None, solnorm=None, minblperant=None, minsnr=None, smodel=None, splinetime=None, npointaver=None, phasewrap=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Determine temporal gains from calibrator observations

	Detailed Description: 

The time depednend complex gains for each antenna/spwid are determined
from the raw data (DATA column) divided by the model (MODEL column), for the
specified fields.  The gains are computed independently for each specified
spectral window.

Previous calibrations are applied on the fly.


	Arguments :
		vis:	List of input MeasurementSets
		   Default Value: 

		caltable:	List of output caltables
		   Default Value: 

		field:	Set of data selection field names or ids
		   Default Value: 

		intent:	Set of data selection observing intents
		   Default Value: 

		spw:	Set of data selection spectral window/channels
		   Default Value: 

		antenna:	Set of data selection antenna ids
		   Default Value: 

		hm_gaintype:	The gain solution type (gtype or gpsline)
		   Default Value: gtype
		   Allowed Values:
				gtype
				gpline
				

		calmode:	Type of solution" (ap, p, a)
		   Default Value: ap
		   Allowed Values:
				a
				p
				ap

		solint:	Solution intervals
		   Default Value: inf

		combine:	Data axes which to combine for solve (scan, spw, and/or field)
		   Default Value: 

		refant:	Reference antenna names
		   Default Value: 

		solnorm:	Normalize average solution amplitudes to 1.0
		   Default Value: False

		minblperant:	Minimum baselines per antenna required for solve
		   Default Value: 4

		minsnr:	Reject solutions below this SNR
		   Default Value: 3.0

		smodel:	Point source Stokes parameters for source model
		   Default Value: 

		splinetime:	Spline timescale(sec)
		   Default Value: 3600.0

		npointaver:	The phase-unwrapping algorithm
		   Default Value: 3

		phasewrap:	Wrap the phase for jumps greater than this value (degrees)
		   Default Value: 180.0

		pipelinemode:	The pipeline operating mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run task (False) or display the command(True)
		   Default Value: False

		acceptresults:	Automatically accept results into the context
		   Default Value: True

	Returns: void

	Example :


Compute the gain solutions.

---- pipeline parameter arguments which can be set in any pipeline mode

pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
       determines the values of all context defined pipeline inputs
       automatically.  In interactive mode the user can set the pipeline
       context defined parameters manually.  In 'getinputs' mode the user
       can check the settings of all pipeline parameters without running
       the task.
       default: 'automatic'.

hm_gtype -- The type of gain calibration. The options are 'gtype' and
    'gspline' for CASA gain types = 'G' and 'GSPLINE' respectively.

calmode -- Type of solution, The options are 'ap' (amp and phase), 'p'
    (phase only) and 'a' (amp only)
    default: 'ap'
    options: 'p','a','ap'

solint --  Time solution intervals in CASA syntax. Works for hm_gtype='gtype'
    only.
    default: 'inf'
    example: 'inf', 'int', '100sec'

combine -- Data axes to combine for solving. Options are  '','scan','spw',field'
    or any comma-separated combination. Works for hm_gtype='gtype' only.
    default; ''
    example: combine=''

minblperant -- Minimum number of baselines required per antenna for each solve
    Antennas with fewer baselines are excluded from solutions. Works for
    hm_gtype='gtype' only.
    default: 4
    example: minblperant=2

minsnr -- Solutions below this SNR are rejected. Works for hm_gtype=
    'channel' only
    default: 3.0

splinetime -- Spline timescale (sec). Used for hm_gtype='gspline'.  Typical
    splinetime should cover about 3 to 5 calibrator scans.
    default: 3600 (1 hour)
    example: splinetime=1000

npointaver -- Tune phase-unwrapping algorithm. Used for hm_gtype='gspline'
    default: 3 (Keep at this value)

phasewrap -- Wrap the phase for changes larger than this amount (degrees)
    Used for hm_gtype='gspline'.
    default: 180 (Keep at this value)


---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- The list of input MeasurementSets. Defaults to the list of MeasurementSets
    specified in the pipeline context
    default: ''
    example: ['M82A.ms', 'M82B.ms'] 

caltable -- The list of output calibration tables. Defaults to the standard
    pipeline naming convention.
    default: ''
    example: ['M82.gcal', 'M82B.gcal']

field -- The list of field names or field ids for which gain solutions are
    to be computed. Defaults to all fields with the standard intent.
    default: '' 
    example: '3C279', '3C279, M82'

intent -- A string containing a comma delimited list of intents against
    which the the selected fields are matched. Defaults to *PHASE*.
    default: '' 
    example: '', '*AMP*,*PHASE*'

spw -- The list of spectral windows and channels for which gain solutions are
    computed. Defaults to all science spectral windows.
    default: '' 
    example: '3C279', '3C279, M82'

smodel -- Point source Stokes parameters for source model (experimental)
    Defaults to using standard MODEL_DATA column data.
    default: [] 
    example: [1,0,0,0] (I=1, unpolarized)

refant -- Reference antenna name(s) in priority order. Defaults to most recent
    values set in the pipeline context.  If no reference antenna is defined in
    the pipeline context use the CASA defaults.
    default: '' 
    example: refant='DV01', refant='DV05,DV07'

solnorm -- Normalise the gain solutions
    default: False

--- pipeline task execution modes
dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: False

acceptresults -- Add the results of the task to the pipeline context (True) or
   reject them (False).
   default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned

Description

The complex gains  are derived from the data column (raw data) divided
by the model column (usually set with hif_setjy). The gains are obtained for a
specified solution interval, spw combination and field combination.

Good candidate reference antennas can be determined using the hif_refant
task.

Previous calibrations that have been stored in the pipeline context are
applied on the fly. Users can interact with these calibrations via the
hif_export_calstate and hif_import_calstate tasks.

Issues

The 'gspline' (smooth) option is still under development in CASA.

Examples

1. Compute standard per scan gain solutions that will be used to calibrate
the target.

    hif_gaincal()



        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_gaincal'
        self.__globals__['taskname'] = 'hif_gaincal'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['vis'] = vis = self.parameters['vis']
            myparams['caltable'] = caltable = self.parameters['caltable']
            myparams['field'] = field = self.parameters['field']
            myparams['intent'] = intent = self.parameters['intent']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['antenna'] = antenna = self.parameters['antenna']
            myparams['hm_gaintype'] = hm_gaintype = self.parameters['hm_gaintype']
            myparams['calmode'] = calmode = self.parameters['calmode']
            myparams['solint'] = solint = self.parameters['solint']
            myparams['combine'] = combine = self.parameters['combine']
            myparams['refant'] = refant = self.parameters['refant']
            myparams['solnorm'] = solnorm = self.parameters['solnorm']
            myparams['minblperant'] = minblperant = self.parameters['minblperant']
            myparams['minsnr'] = minsnr = self.parameters['minsnr']
            myparams['smodel'] = smodel = self.parameters['smodel']
            myparams['splinetime'] = splinetime = self.parameters['splinetime']
            myparams['npointaver'] = npointaver = self.parameters['npointaver']
            myparams['phasewrap'] = phasewrap = self.parameters['phasewrap']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(vis)==str: vis=[vis]
        if type(caltable)==str: caltable=[caltable]
        if type(smodel)==float: smodel=[smodel]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['caltable'] = caltable
        mytmp['field'] = field
        mytmp['intent'] = intent
        mytmp['spw'] = spw
        mytmp['antenna'] = antenna
        mytmp['hm_gaintype'] = hm_gaintype
        mytmp['calmode'] = calmode
        mytmp['solint'] = solint
        mytmp['combine'] = combine
        mytmp['refant'] = refant
        mytmp['solnorm'] = solnorm
        mytmp['minblperant'] = minblperant
        mytmp['minsnr'] = minsnr
        mytmp['smodel'] = smodel
        mytmp['splinetime'] = splinetime
        mytmp['npointaver'] = npointaver
        mytmp['phasewrap'] = phasewrap
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_gaincal.xml')

        casalog.origin('hif_gaincal')
	try :
          #if not trec.has_key('hif_gaincal') or not casac.casac.utils().verify(mytmp, trec['hif_gaincal']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_gaincal'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_gaincal', 'hif_gaincal.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_gaincal'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_gaincal(vis, caltable, field, intent, spw, antenna, hm_gaintype, calmode, solint, combine, refant, solnorm, minblperant, minsnr, smodel, splinetime, npointaver, phasewrap, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_gaincal'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_gaincal', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['hm_gaintype']  = 'gtype'
        a['calmode']  = 'ap'
        a['pipelinemode']  = 'automatic'

        a['hm_gaintype'] = {
                    0:odict([{'value':'gtype'}, {'solint':'inf'}, {'combine':''}, {'minblperant':4}, {'minsnr':3.0}]), 
                    1:odict([{'value':'gspline'}, {'splinetime':3600.0}, {'npointaver':3}, {'phasewrap':180.0}])}
        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'vis':[]}, {'caltable':[]}, {'field':''}, {'intent':''}, {'spw':''}, {'antenna':''}, {'smodel':[]}, {'solnorm':False}, {'refant':''}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'vis':[]}, {'caltable':[]}, {'field':''}, {'intent':''}, {'spw':''}, {'antenna':''}, {'smodel':[]}, {'solnorm':False}, {'refant':''}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_gaincal', subkey=None):
        desc={'hif_gaincal': 'Determine temporal gains from calibrator observations',
               'vis': 'List of input MeasurementSets',
               'caltable': 'List of output caltables',
               'field': 'Set of data selection field names or ids',
               'intent': 'Set of data selection observing intents',
               'spw': 'Set of data selection spectral window/channels',
               'antenna': 'Set of data selection antenna ids',
               'hm_gaintype': 'The gain solution type (gtype or gpsline)',
               'calmode': 'Type of solution" (ap, p, a)',
               'solint': 'Solution intervals',
               'combine': 'Data axes which to combine for solve (scan, spw, and/or field)',
               'refant': 'Reference antenna names',
               'solnorm': 'Normalize average solution amplitudes to 1.0',
               'minblperant': 'Minimum baselines per antenna required for solve',
               'minsnr': 'Reject solutions below this SNR',
               'smodel': 'Point source Stokes parameters for source model',
               'splinetime': 'Spline timescale(sec)',
               'npointaver': 'The phase-unwrapping algorithm',
               'phasewrap': 'Wrap the phase for jumps greater than this value (degrees)',
               'pipelinemode': 'The pipeline operating mode',
               'dryrun': 'Run task (False) or display the command(True)',
               'acceptresults': 'Automatically accept results into the context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['vis']  = ['']
        a['caltable']  = ['']
        a['field']  = ''
        a['intent']  = ''
        a['spw']  = ''
        a['antenna']  = ''
        a['hm_gaintype']  = 'gtype'
        a['calmode']  = 'ap'
        a['solint']  = 'inf'
        a['combine']  = ''
        a['refant']  = ''
        a['solnorm']  = False
        a['minblperant']  = 4
        a['minsnr']  = 3.0
        a['smodel']  = []
        a['splinetime']  = 3600.0
        a['npointaver']  = 3
        a['phasewrap']  = 180.0
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['hm_gaintype']  == 'gtype':
            a['solint'] = 'inf'
            a['combine'] = ''
            a['minblperant'] = 4
            a['minsnr'] = 3.0

        if self.parameters['hm_gaintype']  == 'gspline':
            a['splinetime'] = 3600.0
            a['npointaver'] = 3
            a['phasewrap'] = 180.0

        if self.parameters['pipelinemode']  == 'interactive':
            a['vis'] = []
            a['caltable'] = []
            a['field'] = ''
            a['intent'] = ''
            a['spw'] = ''
            a['antenna'] = ''
            a['smodel'] = []
            a['solnorm'] = False
            a['refant'] = ''
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['vis'] = []
            a['caltable'] = []
            a['field'] = ''
            a['intent'] = ''
            a['spw'] = ''
            a['antenna'] = ''
            a['smodel'] = []
            a['solnorm'] = False
            a['refant'] = ''

        if a.has_key(paramname) :
	      return a[paramname]
hif_gaincal_cli = hif_gaincal_cli_()
