#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_hif_editimlist import hif_editimlist
class hif_editimlist_cli_:
    __name__ = "hif_editimlist"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (hif_editimlist_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'imagename':None, 'search_radius_arcsec':None, 'cell':None, 'conjbeams':None, 'cyclefactor':None, 'cycleniter':None, 'deconvolver':None, 'editmode':None, 'field':None, 'imaging_mode':None, 'imsize':None, 'intent':None, 'gridder':None, 'mask':None, 'nbin':None, 'nchan':None, 'niter':None, 'nterms':None, 'parameter_file':None, 'phasecenter':None, 'reffreq':None, 'robust':None, 'scales':None, 'specmode':None, 'spw':None, 'start':None, 'stokes':None, 'sensitivity':None, 'threshold':None, 'threshold_nsigma':None, 'uvtaper':None, 'uvrange':None, 'width':None, 'pipelinemode':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, imagename=None, search_radius_arcsec=None, cell=None, conjbeams=None, cyclefactor=None, cycleniter=None, deconvolver=None, editmode=None, field=None, imaging_mode=None, imsize=None, intent=None, gridder=None, mask=None, nbin=None, nchan=None, niter=None, nterms=None, parameter_file=None, phasecenter=None, reffreq=None, robust=None, scales=None, specmode=None, spw=None, start=None, stokes=None, sensitivity=None, threshold=None, threshold_nsigma=None, uvtaper=None, uvrange=None, width=None, pipelinemode=None, dryrun=None, acceptresults=None, ):

        """Add to a list of images to be produced with hif_makeimages()

	Detailed Description: 

            Add to a list of images to be produced with hif_makeimages(), which uses hif_tclean() to invoke CASA tclean.  
	    Many of the hif_editimlist() inputs map directly to tclean parameters.
        
	Arguments :
		imagename:	Prefix for output image names.
		   Default Value: 

		search_radius_arcsec:	Size of the field finding beam search radius in arcsec.
		   Default Value: 

		cell:	Image X and Y cell size(s) with units or pixels per beam, \'\' for default. Single value same for both. \'<number>ppb\' for pixels per beam.
		   Default Value: 

		conjbeams:	Use conjugate frequency in tclean for wideband A-terms.
		   Default Value: False

		cyclefactor:	Controls the depth of clean in minor cycles based on PSF. 
		   Default Value: 

		cycleniter:	Controls max number of minor cycle iterations in a single major cycle.
		   Default Value: 500

		deconvolver:	Minor cycle algorithm (multiscale or mtmfs)
		   Default Value: 

		editmode:	The edit mode of the task (e.g. add, edit)
		   Default Value: 

		field:	Set of data selection field names or ids, \'\' for all
		   Default Value: 

		imaging_mode:	Identity of product type (e.g. VLASS quick look) desired.  This will determine the heuristics used.
		   Default Value: 

		imsize:	Image X and Y size(s) in pixels or PB level (single fields), \'\' for default. Single value same for both. \'<number>pb\' for PB level.
		   Default Value: 

		intent:	Set of data selection intents
		   Default Value: 

		gridder:	Name of the gridder to use with tclean
		   Default Value: 

		mask:	Used to declare whether to use a predefined mask for tclean.
		   Default Value: 

		nbin:	Channel binning factors per spw, \'\' for default.
		   Default Value: 

		nchan:	Number of channels, -1 = all
		   Default Value: 

		niter:	Maximum number of clean iterations
		   Default Value: 20000

		nterms:	
		   Default Value: 2

		parameter_file:	
		   Default Value: 

		phasecenter:	Image center (direction or field index, \'\' for default)
		   Default Value: 

		reffreq:	
		   Default Value: 

		robust:	Robustness parameter for Briggs weighting.

                    robust = -2.0 maps to uniform weighting.
                    robust = +2.0 maps to natural weighting.
                    (robust=0.5 is equivalent to robust=0.0 in AIPS IMAGR.)

                
		   Default Value: 1.0
		   Allowed Values:
				-2.0
				2.0

		scales:	The scales for multi-scale imaging.
		   Default Value: 

		specmode:	Spectral gridding type (mfs, cont, cube, \'\' for default)
		   Default Value: 

		spw:	Set of data selection spectral window/channels, \'\' for all
		   Default Value: 

		start:	Channel start, \'\' for default
		   Default Value: 

		stokes:	
		   Default Value: 

		sensitivity:	
		   Default Value: 0.0

		threshold:	
		   Default Value: 

		threshold_nsigma:	
		   Default Value: 4.0

		uvtaper:	Used to set a uv-taper during clean.
		   Default Value: 

		uvrange:	Set of data selection uv ranges, \'\' for all.
		   Default Value: 

		width:	Channel width, \'\' for default.
		   Default Value: 

		pipelinemode:	The pipeline operating mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		dryrun:	Run the task (False) or display the command(True)
		   Default Value: False

		acceptresults:	Add the results to the pipeline context
		   Default Value: True

	Returns: void

	Example :


            Edit a list of images to be cleaned.

            Keyword Arguments

            
            imagename --

            cell -- Cell size (x, y)
            default '' Compute cell size based on the UV coverage of all the fields
            to be imaged and use a 5 pix per beam sampling.
            The pix per beam specification uses the above default cell size
            ('5ppb') and scales it accordingly.
            example: ['0.5arcsec', '0.5arcsec'] '3ppb'

            conjbeams -- Use conjugate frequency in tclean for wideband A-terms.
            default: False

            cyclefactor -- Controls the depth of clean in minor cycles based on PSF.

            cycleniter -- Controls max number of minor cycle iterations in a single major cycle.

            deconvolver -- Minor cycle algorithm e.g. 'multiscale' or 'mtmfs'.
            default: 'multiscale'

            
            editmode --

            field -- Select fields to image. Use field name(s) NOT id(s). Mosaics
            are assumed to have common source / field names. If intent is specified
            only fields with data matching the intent will be selected. The fields
            will be selected from MeasurementSets in 'vis'.
            default: [''] Fields matching matching intent, one image per target source.
            example: ['3C279'], ['Centaurus*'], ['3C279' ,'J1427-421']

            imsize -- Image X and Y size in pixels or PB level for single field. The
            explicit sizes must be even and divisible by 2,3,5,7 only.
            default: '' The default values are derived as follows:
            1. Determine phase center and spread of field centers around it.
            2. Set the size of the image to cover the spread of field centers plus
            a border of width 0.75 * beam radius, to first null.
            3. Divide X and Y extents by cell size to arrive at the number of
            pixels required.
            The PB level setting for single fields leads to an imsize extending
            to the specified level plus 5% padding in all directions.
            example: [120, 120], '0.3pb'

            intent -- Select intents for which associated fields will be imaged.
            default: 'TARGET'
            example: 'PHASE,BANDPASS'

            
            gridder --

            mask -- Used to declare whether to use a predefined mask for tclean,
            or to use internal auto-masking, or to not mask at all.

            nbin -- Channel binning factors per spw
            default: '' Binning factors for each spw. Format: 'spw1:nb1,spw2:nb2,...'
            Optional wildcard: '*:nb'
            example: '9:2,11:4,13:2,15:8'
            '*:2'

            nchan -- Total number of channels in the output image(s)
            default: -1 Selects enough channels to cover the data selected by
            spw consistent with start and width.
            example: 100

            niter -- The maximum total number of minor cycle iterations allowed for tclean.

            
            nterms --

            
            parameter_file --

            phasecenter -- Direction measure or field id of the image center.
            default: '' The default phase center is set to the mean of the field
            directions of all fields that are to be image together.
            example: 0, 'J2000 19h30m00 -40d00m00'

	    
	    reffreq --


            robust -- Set the Briggs robustness factor for weighting. In general,
            we choose a value that gives suitable PSF size (~2.5? for the
            untapered images) and reasonable sensitivity. Tuning might be needed
            in certain regions.

            scales -- The scales for multi-scale imaging.

            specmode -- Frequency imaging mode, 'mfs', 'cont', 'cube'. \'\' defaults to
            'cube' if intent parameter includes 'TARGET' otherwise 'mfs'.
            default: ''
            example: 'mfs', 'cont', 'cube'
            example:
            mode='mfs' produce one image per source and spw
            mode='cont' produce one image per source and aggregate over all
            specified spws
            mode='cube' produce an LSRK frequency cube, channels are specified
            in frequency

            spw -- Select spectral window/channels to image.
            default: '' Individual images will be computed for all science spectral
            windows.
            example: '9'

            start -- First channel for frequency mode images.
            default '' Starts at first input channel of the spw.
            example: '22.3GHz'

            
            stokes --

            
            threshold --

            uvtaper -- Used to set a uv-taper during clean. At mid-declinations and
            reasonable elevations, not required for the full-resolution images
            and in the QLIP. Needed when making the tapered Images for other BDPs
            (SEIP, CIP). May be useful in QLIP to control PSF at low elevations
            or in hybrid.

            uvrange -- Select a set of uv ranges to image.
            default: '' All uv data is included
            example: '0~1000klambda', ['0~100klambda', 100~1000klambda]

            width -- Output channel width.
            default: '' Difference in frequency between first 2 selected channels.
            for frequency mode images.
            example: '24.2kHz'
            'pilotimage' for 15 MHz / 8 channel heuristic

            --- pipeline task execution modes

            pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
            determines the values of all context defined pipeline inputs automatically.
            In 'interactive' mode the user can set the pipeline context defined
            parameters manually. In 'getinputs' mode the user can check the settings
            of all pipeline parameters without running the task.
            default: 'automatic'.

            dryrun -- Run the commands (True) or generate the commands to be run but
            do not execute (False).
            default: False

            acceptresults -- Add the results of the task to the pipeline context (True) or
            reject them (False).
            default: True

            Output

            results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
            the results object for the pipeline task is returned.

            Description

            Edit a list of images to be cleaned.

            Issues

            

            Examples

            

        
        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'hif_editimlist'
        self.__globals__['taskname'] = 'hif_editimlist'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['imagename'] = imagename = self.parameters['imagename']
            myparams['search_radius_arcsec'] = search_radius_arcsec = self.parameters['search_radius_arcsec']
            myparams['cell'] = cell = self.parameters['cell']
            myparams['conjbeams'] = conjbeams = self.parameters['conjbeams']
            myparams['cyclefactor'] = cyclefactor = self.parameters['cyclefactor']
            myparams['cycleniter'] = cycleniter = self.parameters['cycleniter']
            myparams['deconvolver'] = deconvolver = self.parameters['deconvolver']
            myparams['editmode'] = editmode = self.parameters['editmode']
            myparams['field'] = field = self.parameters['field']
            myparams['imaging_mode'] = imaging_mode = self.parameters['imaging_mode']
            myparams['imsize'] = imsize = self.parameters['imsize']
            myparams['intent'] = intent = self.parameters['intent']
            myparams['gridder'] = gridder = self.parameters['gridder']
            myparams['mask'] = mask = self.parameters['mask']
            myparams['nbin'] = nbin = self.parameters['nbin']
            myparams['nchan'] = nchan = self.parameters['nchan']
            myparams['niter'] = niter = self.parameters['niter']
            myparams['nterms'] = nterms = self.parameters['nterms']
            myparams['parameter_file'] = parameter_file = self.parameters['parameter_file']
            myparams['phasecenter'] = phasecenter = self.parameters['phasecenter']
            myparams['reffreq'] = reffreq = self.parameters['reffreq']
            myparams['robust'] = robust = self.parameters['robust']
            myparams['scales'] = scales = self.parameters['scales']
            myparams['specmode'] = specmode = self.parameters['specmode']
            myparams['spw'] = spw = self.parameters['spw']
            myparams['start'] = start = self.parameters['start']
            myparams['stokes'] = stokes = self.parameters['stokes']
            myparams['sensitivity'] = sensitivity = self.parameters['sensitivity']
            myparams['threshold'] = threshold = self.parameters['threshold']
            myparams['threshold_nsigma'] = threshold_nsigma = self.parameters['threshold_nsigma']
            myparams['uvtaper'] = uvtaper = self.parameters['uvtaper']
            myparams['uvrange'] = uvrange = self.parameters['uvrange']
            myparams['width'] = width = self.parameters['width']
            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']

        if type(cell)==str: cell=[cell]
        if type(field)==str: field=[field]
        if type(imsize)==str: imsize=[imsize]

	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['imagename'] = imagename
        mytmp['search_radius_arcsec'] = search_radius_arcsec
        mytmp['cell'] = cell
        mytmp['conjbeams'] = conjbeams
        mytmp['cyclefactor'] = cyclefactor
        mytmp['cycleniter'] = cycleniter
        mytmp['deconvolver'] = deconvolver
        mytmp['editmode'] = editmode
        mytmp['field'] = field
        mytmp['imaging_mode'] = imaging_mode
        mytmp['imsize'] = imsize
        mytmp['intent'] = intent
        mytmp['gridder'] = gridder
        mytmp['mask'] = mask
        mytmp['nbin'] = nbin
        mytmp['nchan'] = nchan
        mytmp['niter'] = niter
        mytmp['nterms'] = nterms
        mytmp['parameter_file'] = parameter_file
        mytmp['phasecenter'] = phasecenter
        mytmp['reffreq'] = reffreq
        mytmp['robust'] = robust
        mytmp['scales'] = scales
        mytmp['specmode'] = specmode
        mytmp['spw'] = spw
        mytmp['start'] = start
        mytmp['stokes'] = stokes
        mytmp['sensitivity'] = sensitivity
        mytmp['threshold'] = threshold
        mytmp['threshold_nsigma'] = threshold_nsigma
        mytmp['uvtaper'] = uvtaper
        mytmp['uvrange'] = uvrange
        mytmp['width'] = width
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.casac.utils().torecord(pathname+'hif_editimlist.xml')

        casalog.origin('hif_editimlist')
	try :
          #if not trec.has_key('hif_editimlist') or not casac.casac.utils().verify(mytmp, trec['hif_editimlist']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['hif_editimlist'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('hif_editimlist', 'hif_editimlist.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'hif_editimlist'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = hif_editimlist(imagename, search_radius_arcsec, cell, conjbeams, cyclefactor, cycleniter, deconvolver, editmode, field, imaging_mode, imsize, intent, gridder, mask, nbin, nchan, niter, nterms, parameter_file, phasecenter, reffreq, robust, scales, specmode, spw, start, stokes, sensitivity, threshold, threshold_nsigma, uvtaper, uvrange, width, pipelinemode, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'hif_editimlist'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('hif_editimlist', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['imagename']  = ''
        a['search_radius_arcsec']  = ''
        a['cell']  = ['']
        a['conjbeams']  = False
        a['cyclefactor']  = ''
        a['cycleniter']  = 500
        a['deconvolver']  = ''
        a['editmode']  = ''
        a['field']  = ['']
        a['imaging_mode']  = ''
        a['imsize']  = ['']
        a['intent']  = ''
        a['gridder']  = ''
        a['mask']  = ''
        a['nbin']  = ''
        a['nchan']  = ''
        a['niter']  = 20000
        a['nterms']  = 2
        a['parameter_file']  = ''
        a['phasecenter']  = ''
        a['reffreq']  = ''
        a['scales']  = ''
        a['specmode']  = ''
        a['spw']  = ''
        a['start']  = ''
        a['stokes']  = ''
        a['sensitivity']  = 0.0
        a['threshold']  = ''
        a['threshold_nsigma']  = 4.0
        a['uvtaper']  = ''
        a['uvrange']  = ''
        a['width']  = ''
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True


### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='hif_editimlist', subkey=None):
        desc={'hif_editimlist': 'Add to a list of images to be produced with hif_makeimages()',
               'imagename': 'Prefix for output image names.',
               'search_radius_arcsec': 'Size of the field finding beam search radius in arcsec.',
               'cell': 'Image X and Y cell size(s) with units or pixels per beam, \'\' for default. Single value same for both. \'<number>ppb\' for pixels per beam.',
               'conjbeams': 'Use conjugate frequency in tclean for wideband A-terms.',
               'cyclefactor': 'Controls the depth of clean in minor cycles based on PSF. ',
               'cycleniter': 'Controls max number of minor cycle iterations in a single major cycle.',
               'deconvolver': 'Minor cycle algorithm (multiscale or mtmfs)',
               'editmode': 'The edit mode of the task (e.g. add, edit)',
               'field': 'Set of data selection field names or ids, \'\' for all',
               'imaging_mode': 'Identity of product type (e.g. VLASS quick look) desired.  This will determine the heuristics used.',
               'imsize': 'Image X and Y size(s) in pixels or PB level (single fields), \'\' for default. Single value same for both. \'<number>pb\' for PB level.',
               'intent': 'Set of data selection intents',
               'gridder': 'Name of the gridder to use with tclean',
               'mask': 'Used to declare whether to use a predefined mask for tclean.',
               'nbin': 'Channel binning factors per spw, \'\' for default.',
               'nchan': 'Number of channels, -1 = all',
               'niter': 'Maximum number of clean iterations',
               'nterms': '',
               'parameter_file': '',
               'phasecenter': 'Image center (direction or field index, \'\' for default)',
               'reffreq': '',
               'robust': 'Robustness parameter',
               'scales': 'The scales for multi-scale imaging.',
               'specmode': 'Spectral gridding type (mfs, cont, cube, \'\' for default)',
               'spw': 'Set of data selection spectral window/channels, \'\' for all',
               'start': 'Channel start, \'\' for default',
               'stokes': '',
               'sensitivity': '',
               'threshold': '',
               'threshold_nsigma': '',
               'uvtaper': 'Used to set a uv-taper during clean.',
               'uvrange': 'Set of data selection uv ranges, \'\' for all.',
               'width': 'Channel width, \'\' for default.',
               'pipelinemode': 'The pipeline operating mode',
               'dryrun': 'Run the task (False) or display the command(True)',
               'acceptresults': 'Add the results to the pipeline context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['imagename']  = ''
        a['search_radius_arcsec']  = ''
        a['cell']  = ['']
        a['conjbeams']  = False
        a['cyclefactor']  = ''
        a['cycleniter']  = 500
        a['deconvolver']  = ''
        a['editmode']  = ''
        a['field']  = ['']
        a['imaging_mode']  = ''
        a['imsize']  = ['']
        a['intent']  = ''
        a['gridder']  = ''
        a['mask']  = ''
        a['nbin']  = ''
        a['nchan']  = ''
        a['niter']  = 20000
        a['nterms']  = 2
        a['parameter_file']  = ''
        a['phasecenter']  = ''
        a['reffreq']  = ''
        a['robust']  = 1.0
        a['scales']  = ''
        a['specmode']  = ''
        a['spw']  = ''
        a['start']  = ''
        a['stokes']  = ''
        a['sensitivity']  = 0.0
        a['threshold']  = ''
        a['threshold_nsigma']  = 4.0
        a['uvtaper']  = ''
        a['uvrange']  = ''
        a['width']  = ''
        a['pipelinemode']  = 'automatic'
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if a.has_key(paramname) :
	      return a[paramname]
hif_editimlist_cli = hif_editimlist_cli_()
