#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_hif_atmflag
def hif_atmflag(vis=[''], intent='*AMP*,*BANDPASS*,*PHASE*', flag_minabs=False, fmin_limit=0.1, flag_nmedian=False, fnm_lo_limit=0.5, fnm_hi_limit=1E9, pipelinemode='automatic', dryrun=False, acceptresults=True):

        """Flag channels with bad atmospheric transmission

hif_atmflag flags channels where the atmospheric transmission is low

Keyword arguments:

pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
   determines the values of all context defined pipeline inputs automatically.
   In interactive mode the user can set the pipeline context defined parameters
   manually.  In 'getinputs' mode the user can check the settings of all
   pipeline parameters without running the task.
   default: 'automatic'.

---- pipeline parameter arguments which can be set in any pipeline mode

intents -- Specifies the data intents whose channels are to be flagged
           if they have low atmospheric transmission. This string is 
           inserted into the flagcmd given to the flagdata task 
           applying the flags; it must have a valid flagcmd format.
    default '*AMP*,*BANDPASS*,*PHASE*'  

flag_minabs -- True to flag channels with transmission less than fmin_limit.
    default False

fmin_limit -- The atmospheric transmission below which channels are to be
              flagged if flag_minabs is True.
    default 0.1

flag_nmedian -- True to flag channels based on transmission deviation from the
                median.
    default: False

fnm_lo_limit -- Flag channels with transmission less than fnm_lo_limit *
                median transmission, if flag_nmedian is True.
    default: 0.5

fnm_hi_limit -- Flag channels with transmission greater than fnm_hi_limit *
                median transmission, if flag_nmedian is True.
    default: 1E9

---- pipeline context defined parameter arguments which can be set only in
'interactive mode'

vis -- List of input MeasurementSets
    default: [] - Use the MeasurementSets currently stored in the pipeline context. 
    example: vis=['X132.ms']

-- Pipeline task execution modes

dryrun -- Run the commands (True) or generate the commands to be run but
   do not execute (False).
   default: True

acceptresults -- This parameter has no effect. The Tsyscal file is already
                 in the pipeline context and is flagged in situ.

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
           the results object for the pipeline task is returned.

Description

Spectral window channels with low atmospheric transmission are identified 
and flagged. The flagging view comprises a transmission spectrum for each
spectral window calculated using the CASA atmosphere model.

Flags are generated by running the following rules on each spectrum:

If flag_minabs = True then channels with transmission below fmin_limit
are flagged.

If flag_nmedian = True then channels with transmission below fnm_lo_limit *
median transmission or above fnm_hi_limit * median transmission are flagged.

The flagging limits are set by frequency rather than by channel number.
The frequency frame is the native one of the spectral windows, usually TOPO. 

Examples:

1. Flag channels with transmission below 0.1 in each SpW.

   hif_atmflag()
       equivalent to:
   hif_atmflag(flag_minabs=True, fmin_limit=0.1)

2. Flag channels with transmission below 0.4 * median transmission across 
   the spectral window, and above 1.4 * median transmission.
 
   hif_atmflag(flag_nmedian=True, fnm_lo_limit=0.4, fnm_hi_limit=1.4)


        """
        if type(vis)==str: vis=[vis]

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['vis'] = vis
        mytmp['intent'] = intent
        mytmp['flag_minabs'] = flag_minabs
        mytmp['fmin_limit'] = fmin_limit
        mytmp['flag_nmedian'] = flag_nmedian
        mytmp['fnm_lo_limit'] = fnm_lo_limit
        mytmp['fnm_hi_limit'] = fnm_hi_limit
        mytmp['pipelinemode'] = pipelinemode
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/hif/cli/"
	trec = casac.utils().torecord(pathname+'hif_atmflag.xml')

        casalog.origin('hif_atmflag')
        if trec.has_key('hif_atmflag') and casac.utils().verify(mytmp, trec['hif_atmflag']) :
	    result = task_hif_atmflag.hif_atmflag(vis, intent, flag_minabs, fmin_limit, flag_nmedian, fnm_lo_limit, fnm_hi_limit, pipelinemode, dryrun, acceptresults)

	else :
	  result = False
        return result
