#
# This file was generated using xslt from its XML file
#
# Copyright 2014, Associated Universities Inc., Washington DC
#
import sys
import os
#from casac import *
import casac
import string
import time
import inspect
import gc
import numpy
from casa_stack_manip import stack_frame_find
from odict import odict
from types import * 
from task_h_init import h_init
class h_init_cli_:
    __name__ = "h_init"
    rkey = None
    i_am_a_casapy_task = None
    # The existence of the i_am_a_casapy_task attribute allows help()
    # (and other) to treat casapy tasks as a special case.

    def __init__(self) :
       self.__bases__ = (h_init_cli_,)
       self.__doc__ = self.__call__.__doc__

       self.parameters={'pipelinemode':None, 'loglevel':None, 'plotlevel':None, 'output_dir':None, 'weblog':None, 'overwrite':None, 'dryrun':None, 'acceptresults':None, }


    def result(self, key=None):
	    #### and add any that have completed...
	    return None


    def __call__(self, pipelinemode=None, loglevel=None, plotlevel=None, output_dir=None, weblog=None, overwrite=None, dryrun=None, acceptresults=None, ):

        """Initialise the interferometry pipeline

	Detailed Description: 

The h_init task initialises the interferometry pipeline and optionally 
imports data.

	Arguments :
		pipelinemode:	The pipeline operating  mode
		   Default Value: automatic
		   Allowed Values:
				automatic
				interactive
				getinputs

		loglevel:	Log level for pipeline messages
		   Default Value: info
		   Allowed Values:
				trace
				debug
				info
				warning
				error
				critical

		plotlevel:	Level for pipeline plots
		   Default Value: default
		   Allowed Values:
				all
				default
				summary

		output_dir:	The output working directory
		   Default Value: ./

		weblog:	Generate the web log
		   Default Value: True

		overwrite:	Overwrite existing files on import
		   Default Value: True

		dryrun:	Run the task (False) or display the task command (True)
		   Default Value: False

		acceptresults:	Add the results into the pipeline context
		   Default Value: True

	Returns: void

	Example :


The h_init task initialises the interferometry pipeline.


Keyword arguments:

---- pipeline parameter arguments which can be set in any pipeline mode
pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
       determines the values of all context defined pipeline inputs
       automatically.  In interactive mode the user can set the pipeline
       context defined parameters manually.  In 'getinputs' mode the user
       can check the settings of all pipeline parameters without running
       the task.
       default: 'automatic'.

---- pipeline context defined parameter argument which can be set only in
'interactive mode' or 'getinputs' modes 
loglevel -- Pipeline log level threshold: (debug|info|warning|error|critical).
       Log messages below this threshold will not be displayed.  
       default: 'info'

plotlevel -- Pipeline plot level threshold: (all|default|summary).
       Toggle generation of detail plots in the web log. A level of 'all'
       generates all plots; 'summary' omits detail plots; 'default' 
       generates all plots apart from for the hif_applycal task.
       default: 'default'

output_dir -- Working directory for pipeline processing. Some pipeline
       processing products such as HTML logs and images will be directed to
       subdirectories of this path. 
       default: './' (current directory)

weblog -- Toggle web log generation. 

overwrite -- Overwrite existing MSs on input.

--- pipeline task execution modes
dryrun -- Run the commands (True) or generate the commands to be run but
       do not execute (False).
       default: True

acceptresults -- Add the results of the task to the pipeline context (True) or
       reject them (False).
       default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.

Description

h_init  must be called before any other interferometry pipeline task. The
pipeline can be initialised in one of two ways: by creating a new pipeline 
state (h_init) or be loading a saved pipeline state (h_resume).

h_init creates an empty pipeline context but does not load visiblity data
into the context. hif_importdata or hsd_importdata can be used to load data.

Issues

Examples

1. Create the pipeline context

h_init()

        """
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
	#casac = self.__globals__['casac']
	casalog = self.__globals__['casalog']
	casa = self.__globals__['casa']
	#casalog = casac.casac.logsink()
        self.__globals__['__last_task'] = 'h_init'
        self.__globals__['taskname'] = 'h_init'
        ###
        self.__globals__['update_params'](func=self.__globals__['taskname'],printtext=False,ipython_globals=self.__globals__)
        ###
        ###
        #Handle globals or user over-ride of arguments
        #
        if type(self.__call__.func_defaults) is NoneType:
            function_signature_defaults={}
	else:
	    function_signature_defaults=dict(zip(self.__call__.func_code.co_varnames[1:],self.__call__.func_defaults))
	useLocalDefaults = False

        for item in function_signature_defaults.iteritems():
                key,val = item
                keyVal = eval(key)
                if (keyVal == None):
                        #user hasn't set it - use global/default
                        pass
                else:
                        #user has set it - use over-ride
			if (key != 'self') :
			   useLocalDefaults = True

	myparams = {}
	if useLocalDefaults :
	   for item in function_signature_defaults.iteritems():
	       key,val = item
	       keyVal = eval(key)
	       exec('myparams[key] = keyVal')
	       self.parameters[key] = keyVal
	       if (keyVal == None):
	           exec('myparams[key] = '+ key + ' = self.itsdefault(key)')
		   keyVal = eval(key)
		   if(type(keyVal) == dict) :
                      if len(keyVal) > 0 :
		         exec('myparams[key] = ' + key + ' = keyVal[len(keyVal)-1][\'value\']')
		      else :
		         exec('myparams[key] = ' + key + ' = {}')
	 
        else :
            print ''

            myparams['pipelinemode'] = pipelinemode = self.parameters['pipelinemode']
            myparams['loglevel'] = loglevel = self.parameters['loglevel']
            myparams['plotlevel'] = plotlevel = self.parameters['plotlevel']
            myparams['output_dir'] = output_dir = self.parameters['output_dir']
            myparams['weblog'] = weblog = self.parameters['weblog']
            myparams['overwrite'] = overwrite = self.parameters['overwrite']
            myparams['dryrun'] = dryrun = self.parameters['dryrun']
            myparams['acceptresults'] = acceptresults = self.parameters['acceptresults']


	result = None

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['pipelinemode'] = pipelinemode
        mytmp['loglevel'] = loglevel
        mytmp['plotlevel'] = plotlevel
        mytmp['output_dir'] = output_dir
        mytmp['weblog'] = weblog
        mytmp['overwrite'] = overwrite
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/h/cli/"
	trec = casac.casac.utils().torecord(pathname+'h_init.xml')

        casalog.origin('h_init')
	try :
          #if not trec.has_key('h_init') or not casac.casac.utils().verify(mytmp, trec['h_init']) :
	    #return False

          casac.casac.utils().verify(mytmp, trec['h_init'], True)
          scriptstr=['']
          saveinputs = self.__globals__['saveinputs']
          if type(self.__call__.func_defaults) is NoneType:
              saveinputs=''
          else:
              saveinputs('h_init', 'h_init.last', myparams, self.__globals__,scriptstr=scriptstr)
          tname = 'h_init'
          spaces = ' '*(18-len(tname))
          casalog.post('\n##########################################'+
                       '\n##### Begin Task: ' + tname + spaces + ' #####')
          if type(self.__call__.func_defaults) is NoneType:
              casalog.post(scriptstr[0]+'\n', 'INFO')
          else :
              casalog.post(scriptstr[1][1:]+'\n', 'INFO')
          result = h_init(pipelinemode, loglevel, plotlevel, output_dir, weblog, overwrite, dryrun, acceptresults)
          casalog.post('##### End Task: ' + tname + '  ' + spaces + ' #####'+
                       '\n##########################################')

	except Exception, instance:
          if(self.__globals__.has_key('__rethrow_casa_exceptions') and self.__globals__['__rethrow_casa_exceptions']) :
             raise
          else :
             #print '**** Error **** ',instance
	     tname = 'h_init'
             casalog.post('An error occurred running task '+tname+'.', 'ERROR')
             pass

        gc.collect()
        return result
#
#
#
    def paramgui(self, useGlobals=True, ipython_globals=None):
        """
        Opens a parameter GUI for this task.  If useGlobals is true, then any relevant global parameter settings are used.
        """
        import paramgui
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )

        if useGlobals:
	    if ipython_globals == None:
                myf=self.__globals__
            else:
                myf=ipython_globals

            paramgui.setGlobals(myf)
        else:
            paramgui.setGlobals({})

        paramgui.runTask('h_init', myf['_ip'])
        paramgui.setGlobals({})

#
#
#
    def defaults(self, param=None, ipython_globals=None, paramvalue=None, subparam=None):
	if not hasattr(self, "__globals__") or self.__globals__ == None :
           self.__globals__=stack_frame_find( )
        if ipython_globals == None:
            myf=self.__globals__
        else:
            myf=ipython_globals

        a = odict()
        a['pipelinemode']  = 'automatic'

        a['pipelinemode'] = {
                    0:{'value':'automatic'}, 
                    1:odict([{'value':'interactive'}, {'loglevel':'info'}, {'plotlevel':'default'}, {'output_dir':'./'}, {'weblog':True}, {'overwrite':True}, {'dryrun':False}, {'acceptresults':True}]), 
                    2:odict([{'value':'getinputs'}, {'loglevel':'info'}, {'plotlevel':'default'}, {'output_dir':'./'}, {'weblog':True}, {'overwrite':True}])}

### This function sets the default values but also will return the list of
### parameters or the default value of a given parameter
        if(param == None):
                myf['__set_default_parameters'](a)
        elif(param == 'paramkeys'):
                return a.keys()
        else:
            if(paramvalue==None and subparam==None):
               if(a.has_key(param)):
                  return a[param]
               else:
                  return self.itsdefault(param)
            else:
               retval=a[param]
               if(type(a[param])==dict):
                  for k in range(len(a[param])):
                     valornotval='value'
                     if(a[param][k].has_key('notvalue')):
                        valornotval='notvalue'
                     if((a[param][k][valornotval])==paramvalue):
                        retval=a[param][k].copy()
                        retval.pop(valornotval)
                        if(subparam != None):
                           if(retval.has_key(subparam)):
                              retval=retval[subparam]
                           else:
                              retval=self.itsdefault(subparam)
		     else:
                        retval=self.itsdefault(subparam)
               return retval


#
#
    def check_params(self, param=None, value=None, ipython_globals=None):
      if ipython_globals == None:
          myf=self.__globals__
      else:
          myf=ipython_globals
#      print 'param:', param, 'value:', value
      try :
         if str(type(value)) != "<type 'instance'>" :
            value0 = value
            value = myf['cu'].expandparam(param, value)
            matchtype = False
            if(type(value) == numpy.ndarray):
               if(type(value) == type(value0)):
                  myf[param] = value.tolist()
               else:
                  #print 'value:', value, 'value0:', value0
                  #print 'type(value):', type(value), 'type(value0):', type(value0)
                  myf[param] = value0
                  if type(value0) != list :
                     matchtype = True
            else :
               myf[param] = value
            value = myf['cu'].verifyparam({param:value})
            if matchtype:
               value = False
      except Exception, instance:
         #ignore the exception and just return it unchecked
         myf[param] = value
      return value
#
#
    def description(self, key='h_init', subkey=None):
        desc={'h_init': 'Initialise the interferometry pipeline',
               'pipelinemode': 'The pipeline operating  mode',
               'loglevel': 'Log level for pipeline messages',
               'plotlevel': 'Level for pipeline plots',
               'output_dir': 'The output working directory',
               'weblog': 'Generate the web log',
               'overwrite': 'Overwrite existing files on import',
               'dryrun': 'Run the task (False) or display the task command (True)',
               'acceptresults': 'Add the results into the pipeline context',

              }

#
# Set subfields defaults if needed
#

        if(desc.has_key(key)) :
           return desc[key]

    def itsdefault(self, paramname) :
        a = {}
        a['pipelinemode']  = 'automatic'
        a['loglevel']  = 'info'
        a['plotlevel']  = 'default'
        a['output_dir']  = './'
        a['weblog']  = True
        a['overwrite']  = True
        a['dryrun']  = False
        a['acceptresults']  = True

        #a = sys._getframe(len(inspect.stack())-1).f_globals

        if self.parameters['pipelinemode']  == 'interactive':
            a['loglevel'] = 'info'
            a['plotlevel'] = 'default'
            a['output_dir'] = './'
            a['weblog'] = True
            a['overwrite'] = True
            a['dryrun'] = False
            a['acceptresults'] = True

        if self.parameters['pipelinemode']  == 'getinputs':
            a['loglevel'] = 'info'
            a['plotlevel'] = 'default'
            a['output_dir'] = './'
            a['weblog'] = True
            a['overwrite'] = True

        if a.has_key(paramname) :
	      return a[paramname]
h_init_cli = h_init_cli_()
