#
# This file was generated using xslt from its XML file
#
# Copyright 2009, Associated Universities Inc., Washington DC
#
import sys
import os
from  casac import *
import string
from taskinit import casalog
from taskinit import xmlpath
#from taskmanager import tm
import task_h_init
def h_init(pipelinemode='automatic', loglevel='info', plotlevel='default', output_dir='./', weblog=True, overwrite=True, dryrun=False, acceptresults=True):

        """Initialise the interferometry pipeline

The h_init task initialises the interferometry pipeline.


Keyword arguments:

---- pipeline parameter arguments which can be set in any pipeline mode
pipelinemode -- The pipeline operating mode. In 'automatic' mode the pipeline
       determines the values of all context defined pipeline inputs
       automatically.  In interactive mode the user can set the pipeline
       context defined parameters manually.  In 'getinputs' mode the user
       can check the settings of all pipeline parameters without running
       the task.
       default: 'automatic'.

---- pipeline context defined parameter argument which can be set only in
'interactive mode' or 'getinputs' modes 
loglevel -- Pipeline log level threshold: (debug|info|warning|error|critical).
       Log messages below this threshold will not be displayed.  
       default: 'info'

plotlevel -- Pipeline plot level threshold: (all|default|summary).
       Toggle generation of detail plots in the web log. A level of 'all'
       generates all plots; 'summary' omits detail plots; 'default' 
       generates all plots apart from for the hif_applycal task.
       default: 'default'

output_dir -- Working directory for pipeline processing. Some pipeline
       processing products such as HTML logs and images will be directed to
       subdirectories of this path. 
       default: './' (current directory)

weblog -- Toggle web log generation. 

overwrite -- Overwrite existing MSs on input.

--- pipeline task execution modes
dryrun -- Run the commands (True) or generate the commands to be run but
       do not execute (False).
       default: True

acceptresults -- Add the results of the task to the pipeline context (True) or
       reject them (False).
       default: True

Output:

results -- If pipeline mode is 'getinputs' then None is returned. Otherwise
    the results object for the pipeline task is returned.

Description

h_init  must be called before any other interferometry pipeline task. The
pipeline can be initialised in one of two ways: by creating a new pipeline 
state (h_init) or be loading a saved pipeline state (h_resume).

h_init creates an empty pipeline context but does not load visiblity data
into the context. hif_importdata or hsd_importdata can be used to load data.

Issues

Examples

1. Create the pipeline context

h_init()

        """

#
#    The following is work around to avoid a bug with current python translation
#
        mytmp = {}

        mytmp['pipelinemode'] = pipelinemode
        mytmp['loglevel'] = loglevel
        mytmp['plotlevel'] = plotlevel
        mytmp['output_dir'] = output_dir
        mytmp['weblog'] = weblog
        mytmp['overwrite'] = overwrite
        mytmp['dryrun'] = dryrun
        mytmp['acceptresults'] = acceptresults
	pathname="file://"+os.environ.get('CASAPATH').split()[0]+"/pipeline/pipeline/h/cli/"
	trec = casac.utils().torecord(pathname+'h_init.xml')

        casalog.origin('h_init')
        if trec.has_key('h_init') and casac.utils().verify(mytmp, trec['h_init']) :
	    result = task_h_init.h_init(pipelinemode, loglevel, plotlevel, output_dir, weblog, overwrite, dryrun, acceptresults)

	else :
	  result = False
        return result
