/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.type.AtomicType;

public abstract class AbstractStaticContext
implements StaticContext {
    private String baseURI = null;
    private Configuration config;
    private LocationMap locationMap = new LocationMap();
    private Executable executable;
    private String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
    private String defaultElementNamespace = "";
    private boolean backwardsCompatible = false;

    protected void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.executable = new Executable(configuration);
        this.executable.setHostLanguage(54);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    protected final void setDefaultFunctionLibrary() {
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(0));
        functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        functionLibraryList.addFunctionLibrary(new JavaExtensionLibrary(this.getConfiguration()));
        functionLibraryList.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        if (this.config.isAllowExternalFunctions()) {
            functionLibraryList.addFunctionLibrary(this.config.getExtensionBinder());
        }
        this.setFunctionLibrary(functionLibraryList);
    }

    protected final void addFunctionLibrary(FunctionLibrary functionLibrary) {
        FunctionLibrary functionLibrary2 = this.executable.getFunctionLibrary();
        if (!(functionLibrary2 instanceof FunctionLibraryList)) {
            throw new IllegalStateException("Registered function library cannot be extended");
        }
        ((FunctionLibraryList)functionLibrary2).addFunctionLibrary(functionLibrary);
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public int getHostLanguage() {
        return 54;
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration(), this.executable.getCollationTable());
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.executable.getFunctionLibrary();
    }

    public void setFunctionLibrary(FunctionLibrary functionLibrary) {
        this.executable.setFunctionLibrary(functionLibrary);
    }

    public void declareCollation(String string, StringCollator stringCollator, boolean bl) {
        CollationMap collationMap = this.executable.getCollationTable();
        collationMap.setNamedCollation(string, stringCollator);
        if (bl) {
            collationMap.setDefaultCollationName(string);
        }
    }

    public StringCollator getCollation(String string) {
        return this.executable.getCollationTable().getNamedCollation(string);
    }

    public String getDefaultCollationName() {
        return this.executable.getCollationTable().getDefaultCollationName();
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void issueWarning(String string, SourceLocator sourceLocator) {
        System.err.println(string);
    }

    public String getSystemId() {
        return "";
    }

    public int getLineNumber() {
        return -1;
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setDefaultElementNamespace(String string) {
        this.defaultElementNamespace = string;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.defaultFunctionNamespace = string;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setBackwardsCompatibilityMode(boolean bl) {
        this.backwardsCompatible = bl;
    }

    public boolean isInBackwardsCompatibleMode() {
        return this.backwardsCompatible;
    }

    public boolean isAllowedBuiltInType(AtomicType atomicType) {
        return true;
    }

    public LocationProvider getLocationProvider() {
        return this.locationMap;
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        throw new UnsupportedOperationException();
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }
}

